package cn.com.duiba.biz.credits;

import cn.com.duiba.credits.sdk.CreditNotifyParams;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 360借条
 * @author: liupu1
 * @create: 2020/4/22 4:28 PM
 **/
@Service
public class Receipt360Api {

    private static final Logger LOGGER = LoggerFactory.getLogger(Receipt360Api.class);

    @Autowired
    private AppDAO appDAO;

    public SubCreditsMsgWrapper getSubCreditsMessage(SubCreditsMsgWrapper subCreditsMsgWrapper) {

        String encodeUrl = generateTwiceEncodeUrl(subCreditsMsgWrapper.getHttpUrl());

        subCreditsMsgWrapper.setHttpUrl(encodeUrl);

        return subCreditsMsgWrapper;
    }


    public CreditsMessage getSubCreditsMessage(CreditsMessage creditsMessage) {

        String encodeUrl = generateTwiceEncodeUrl(creditsMessage.getHttpUrl());

        creditsMessage.setHttpUrl(encodeUrl);

        return creditsMessage;

    }

    private String generateTwiceEncodeUrl(String url) {
        if (StringUtils.isBlank(url)) {
            return url;
        }
        String host = url.substring(0, url.indexOf('?'));
        String params = url.substring(url.indexOf('?') + 1);
        Map<String, String> paramMap = AssembleTool.getUrlParams(params);
        return AssembleTool.assembleUrlEncodeTwice(host, paramMap);
    }

    public HttpRequestBase getRequestNotify(NotifyQueueDO record, AppDO app, CreditNotifyParams p) {
        Map<String, String> map = new HashMap<>();
        String transfer = record.getTransfer();
        if (StringUtils.isNotBlank(transfer)) {
            map.put("success", Boolean.toString(p.isSuccess()));
            map.put("errorMessage", getString(p.getErrorMessage()));
            map.put("bizId", getString(p.getBizId()));
            map.put("appKey", getString(p.getAppKey()));
            map.put("appSecret", getString(appDAO.getAppSecret(app)));
            map.put("timestamp", getString(Long.valueOf(p.getTimestamp().getTime())));
            map.put("uid", getString(record.getPartnerUserId()));
            map.put("orderNum", getString(p.getOrderNum()));
            map.put("transfer", getString(transfer));
            String sign = SignTool.sign(map);
            map.remove("appSecret");
            map.put("sign", sign);
        } else {
            map = p.toRequestMap(appDAO.getAppSecret(app));
        }
        HttpRequestBase http = new HttpGet(AssembleTool.assembleUrlEncodeTwice(app.getCreditsConsumeNotifyUrl(), map));
        return http;
    }

    private String getString(Object o) {
        return o == null ? "" : o.toString();
    }
}
