package cn.com.duiba.biz.credits;

import cn.com.duiba.consumer.center.api.dto.ConsumerExtraDto;
import cn.com.duiba.consumer.center.api.remoteservice.RemoteConsumerExtraService;
import cn.com.duiba.vo.union.UnionRelationInfoVO;
import cn.hutool.core.lang.Pair;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

/**
 * @Description 银联通用api
 * @Date 2022/3/12
 * @Author WeiChaoChao
 */
@Service
public class UnionCommonApi {

    @Autowired
    private RemoteConsumerExtraService remoteConsumerExtraService;

    /**
     * 查询楼层系统中用户的小程序openId
     *
     * @param consumerId
     * @param unionAppId
     * @return
     */
    public Pair<String, String> getUserOpenIdAndMobile(Long consumerId, String unionAppId) {
        // 银联小程序免登用的是unionId openId作为extra参数
        ConsumerExtraDto consumerExtra = remoteConsumerExtraService.findByConsumerId(consumerId).getResult();
        String mobile = "";
        String openId = "";
        if (Objects.nonNull(consumerExtra) && StringUtils.isNotBlank(consumerExtra.getJson())) {
            JSONObject extra = JSON.parseObject(consumerExtra.getJson());
            mobile = extra.getString("mobile");

            // 一个小程序对应唯一的小程序openId(免登在credits-home-web落库)
            JSONArray jsonExtraArray = extra.getJSONArray("unionLoginAppIdOpenIds");
            if (CollectionUtils.isNotEmpty(jsonExtraArray)) {
                UnionRelationInfoVO unionRelationInfoVO = jsonExtraArray.toJavaList(UnionRelationInfoVO.class).stream()
                        .filter(item -> unionAppId.equals(item.getAppId()))
                        .findFirst()
                        .orElse(null);
                if (unionRelationInfoVO != null) {
                    openId = unionRelationInfoVO.getOpenId();
                }
            }
        }
        return Pair.of(openId, mobile);
    }
}
