package cn.com.duiba.biz.credits;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.constant.WatsonsConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.WatsonsSignUtil;
import cn.com.duiba.wolf.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/**
 * @Description: 屈臣氏定制
 * @Author: fxr
 * @Date: 2019/1/3
 */
@Service
public class WatsonsApi {

    private static final Logger LOGGER = LoggerFactory.getLogger(WatsonsApi.class);

    /**
     * 分隔符
     */
    private static final String DELIMITER = "?";

    @Autowired
    private WatsonsConfig watsonsConfig;
    @Autowired
    private WatsonsNewApi watsonsNewApi;

    /**
     * rpc加积分
     */
    public CreditsMessageDto getAddCreditsMessage(CreditsMessageDto message) {
        if (switchNow()){
            return message;
        }
        String url = message.getHttpUrl();

        List<String> analysisList = analysisUrl(url);
        String newUrl = analysisList.get(0);
        Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));


        JSONObject data = new JSONObject();
        data.put("uid", params.get("uid"));
        data.put("numOfPoint", params.get("credits"));
        data.put("typeCode", "Accrual");
        data.put("productName", "Point Adjustment_for Award points_A");
        data.put("storeId", "1");
        data.put("txnChannel", "System");

        TreeMap<String, String> newParams = new TreeMap<>();
        newParams.put("appId", watsonsConfig.getDuibaIdentifier1());
        newParams.put("certiId", watsonsConfig.getCertiId1());
        newParams.put("date", DateUtils.getSecondStr(new Date()));
        newParams.put("data", data.toJSONString());
        newParams.put("sign", WatsonsSignUtil.getSign(newParams, watsonsConfig.getToken1()));
        newParams.put("token", watsonsConfig.getToken1());

        message.setHttpType(CreditsMessageDto.HTTP_POST);
        message.setHttpUrl(newUrl);
        message.setAuthParams(newParams);

        return message;
    }

    public SubCreditsMsgWrapper getSubCredits(SubCreditsMsgWrapper request) {
        if (switchNow()){
            return request;
        }
        try{
            String url = request.getHttpUrl();
            String host = url.substring(0, url.indexOf('?'));
            request.setHttpUrl(host);
            String params = url.substring(url.indexOf('?') + 1, url.length());
            Map<String, String> paramsMap = AssembleTool.getUrlParams(params);
            request.getSubCreditsMsg().setHttpType(SubCreditsMsgDto.HTTP_POST);
            request.setHttpUrl(AssembleTool.assembleUrl(host, paramsMap));
        }catch (Exception e){
            LOGGER.warn("[watsonsApi- 构建扣积分参数异常]error:{}", e);
        }
        return request;
    }

    public String parseCreditsRsp(String body, Boolean addCredits) {
        if (switchNow()) {
            return watsonsNewApi.parseCreditsRsp(body);
        }
        if (!Boolean.TRUE.equals(addCredits)) {
            return body;
        }

        JSONObject response = JSON.parseObject(body);

        JSONObject json = new JSONObject();
        json.put("errorMessage", response.getString("message"));
        json.put("status", response.getBooleanValue("is_success") ? "ok" : "fail");

        return json.toString();
    }

    private boolean switchNow() {
        return watsonsConfig.getApiSwitchTime().compareTo(System.currentTimeMillis()) < 0;
    }
    /**
     * 构造屈臣氏虚拟权益兑换请求.
     *
     * @param request
     * @return
     */
    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        if (switchNow()) {
            return request;
        }
        String url = request.getHttpUrl();
        //  解析URL
        List<String> analysisList = analysisUrl(url);
        if (analysisList.isEmpty()) {
            return request;
        }
        //  获取屈臣氏网关地址
        String host = analysisList.get(0);

        //  获取URL中拼接的请求参数
        Map<String, String> urlParams = AssembleTool.getUrlParams(analysisList.get(1));

        //  自定义 业务参数
        JSONObject data = new JSONObject();
        data.put("uid", urlParams.get("uid"));
        data.put("keycode", urlParams.get("params"));

        TreeMap<String, String> paramMap = getBaseParam();
        paramMap.put("data", data.toJSONString());

        String sign = WatsonsSignUtil.getSign(paramMap, watsonsConfig.getToken());
        paramMap.put("sign", sign);
        paramMap.put("token", watsonsConfig.getToken());
        request.setHttpUrl(host);
        request.setAuthParams(paramMap);
        return request;
    }

    /**
     * 转义屈臣氏虚拟权益兑换响应.
     *
     * @param body
     * @return
     */
    public String getVirtualRespone(String body) {
        if (switchNow()) {
            return watsonsNewApi.getVirtualResponse(body);
        }
        if (StringUtils.isBlank(body)) {
            return resultFail("屈臣氏虚拟商品接口响应为空");
        }
        try {
            JSONObject originJson = JSON.parseObject(body);
            Boolean isSuccess = originJson.getBoolean("is_success");
            if (isSuccess) {
                return resultSuccessWithData(originJson.getString("data"));
            } else {
                return resultFail(originJson.getString("message"));
            }
        } catch (Exception e) {
            LOGGER.warn("[WatsonsApi-getVirtualRespone]屈臣氏-响应JSON解析错误:", e);
            return resultFail("屈臣氏响应JSON解析错误");
        }
    }

    /**
     * 解析URL，获取网关地址和参数串
     *
     * @param url
     * @return java.lang.String
     * @throw
     */
    private static List<String> analysisUrl(String url) {
        List<String> analysisList = Lists.newArrayList();
        if (StringUtils.isNotBlank(url)) {
            int index = url.indexOf(DELIMITER);
            if (index != -1) {
                analysisList.add(url.substring(0, index));
                analysisList.add(url.substring(index + 1));
            } else {
                analysisList.add(url);
                analysisList.add("");
            }
        }
        return analysisList;
    }

    /**
     * 拼接基础参数
     *
     * @return
     */
    private TreeMap<String, String> getBaseParam() {
        TreeMap<String, String> paramMap = new TreeMap<>();
        paramMap.put("appId", watsonsConfig.getDuibaIdentifier());
        paramMap.put("certiId", watsonsConfig.getCertiId());
        paramMap.put("date", DateUtils.getSecondStr(new Date()));
        return paramMap;
    }

    private String resultFail(String message) {
        JSONObject result = new JSONObject();
        result.put("status", "fail");
        result.put("errorMessage", message);
        return result.toJSONString();
    }

    private String resultSuccessWithData(String data) {
        JSONObject result = new JSONObject();
        result.put("status", "success");
        result.put("data", data);
        return result.toJSONString();
    }

    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        return switchNow() ? watsonsNewApi.getAddCreditsMessageRequest(message) : null;
    }

    public HttpRequestBase getSubCreditsMessage(SubCreditsMsgWrapper message) {
        return switchNow() ? watsonsNewApi.getSubCreditsMessage(message) : null;
    }

    public HttpRequestBase getVirtualRequestHttp(SupplierRequest message) {
        if (switchNow()){
            return watsonsNewApi.getVirtualRequestHttp(message);
        }
        return AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
    }
}

