package cn.com.duiba.biz.credits;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.JsonTool;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author chengsiyi
 * @date 2019/8/28 16:39
 */
@Service
public class YunJiApi {

    private static final Logger logger = LoggerFactory.getLogger(YunJiApi.class);

    public SupplierRequest getVirtualRequest(SupplierRequest request) {
        try {
            String url = request.getHttpUrl();
            //  解析URL
            List<String> analysisList = AssembleTool.analysisUrl(url);
            if (analysisList.isEmpty()) {
                return request;
            }
            //  网关地址
            String host = analysisList.get(0);
            //  请求参数
            Map<String, String> params = AssembleTool.getUrlParams(analysisList.get(1));
            //  自定义 业务参数
            Map<String, String> authParams = new LinkedHashMap<>();
            authParams.put("consumerId", params.get("uid"));
            authParams.put("couponType", params.get("params"));
            authParams.put("key", "yunji");
            // 获取签名信息后，去掉参数中的系统参数
            String sign = SignTool.sign(authParams);
            authParams.put("sign", sign);
            authParams.remove("key");
            request.setHttpUrl(AssembleTool.assembleUrl(host, authParams));
        } catch (Exception e) {
            logger.info("[YunJiApi-getVirtualRequest]error Params:[request={}], Msg:云集-虚拟商品定制逻辑异常", JSONObject.toJSONString(request), e);
        }
        return request;
    }

    public String getVirtualResponse(SupplierRequest message, String body) {
        Map<String, String> duibaDoc = new HashMap<>();
        try {
            JSONObject resultJson = JSONObject.parseObject(body);
            if (null == resultJson) {
                throw new BizException("开发者接口响应内容异常");
            }
            Integer status = resultJson.getInteger("errorCode");
            if (!Objects.equals(0, status)) {
                throw new BizException(resultJson.getString("errorMessage"));
            }
            duibaDoc.put("status", "success");
            duibaDoc.put("data", body);
        } catch (Exception e) {
            duibaDoc.put("status", "fail");
            duibaDoc.put("errorMessage", e.getMessage());
            logger.info("[YunJiApi-getVirtualResponse] Params:[message={},body={}], Msg:云集-虚拟商品接口响应解析异常", JSONObject.toJSONString(message), body, e);
        }
        return JsonTool.objectToJson(duibaDoc);
    }

}
