package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.constant.DisuConfig;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.wolf.cache.AdvancedCacheClient;
import cn.com.duiba.wolf.redis.RedisAtomicClient;
import cn.com.duiba.wolf.redis.RedisLock;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author jdt
 * @date 2021-08-11
 */
@Service
public class DisuApiStrategy implements ApiStrategy {

    private static final Logger LOG = LoggerFactory.getLogger(DisuApiStrategy.class);
    private Long appId = null;

    @Autowired
    private DisuConfig disuConfig;

    @Resource(name = "redisTemplate")
    private AdvancedCacheClient advancedCacheClient;

    @Resource(name = "redisTemplate")
    private RedisAtomicClient redisAtomicClient;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        Map<String, String> authParams = message.getSubCreditsMsg().getAuthParams();
        appId = message.getSubCreditsMsg().getAppId();
        HttpPost httpPost = new HttpPost(disuConfig.getDomain().concat(disuConfig.getIntegralChangeUrl()));
        List<NameValuePair> params = buildCommonCreditsParams(authParams, disuConfig.getSubCreditsType(), disuConfig.getSubCreditsChangeType(), appId);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = new UrlEncodedFormEntity(params, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOG.error("地素 扣减积分请求错误:" + e.getMessage(), e);
            return null;
        }
        formEntity.setContentType("application/x-www-form-urlencoded");
        httpPost.setEntity(formEntity);
        LOG.info("地素减积分，req={}", JSON.toJSONString(params));
        return httpPost;
    }

    /**
     * 扣/加积分请求通用请求参数
     *
     * @param params
     * @return
     * @throws Exception
     */
    private List<NameValuePair> buildCommonCreditsParams(Map<String, String> params, Integer type, Integer changeType, Long appId) {
        List<NameValuePair> result = new ArrayList<>();
        String token = getToken(appId);
        result.add(new BasicNameValuePair("token", token));
        result.add(new BasicNameValuePair("entMicroSignal", disuConfig.getEntMicroSignal()));
        result.add(new BasicNameValuePair("unionid", params.get("uid")));
        result.add(new BasicNameValuePair("factoryCode", disuConfig.getFactoryCode()));
        Integer credits = Integer.valueOf(params.get("credits"));
        result.add(new BasicNameValuePair("integral", credits.toString()));
        result.add(new BasicNameValuePair("type", type.toString()));
        result.add(new BasicNameValuePair("changeType", changeType.toString()));
        result.add(new BasicNameValuePair("remark", "拆盲盒" + appId));
        result.add(new BasicNameValuePair("integralFlow", params.get("orderNum")));
        return result;
    }


    @Override
    public String parseCreditsRsp(String body, Boolean addCredits, Map<String, String> authParams) {
        if (addCredits) {
            LOG.info("地素加积分，resp={}", body);
        } else {
            LOG.info("地素减积分，resp={}", body);
        }
        Map<String, String> map = Maps.newHashMap();
        if (StringUtils.isBlank(body)) {
            map.put("status", "fail");
            map.put("errorMessage", "地素新增/扣减积分接口返回为空");
            return JSON.toJSONString(map);
        }
        try {
            JSONObject jsonObject = JSONObject.parseObject(body);
            LOG.info("地素 解析加积分/扣积分结果，json={}", JSON.toJSONString(jsonObject));
            JSONObject integralChange_response = jsonObject.getJSONObject("integralChange_response");
            String result = integralChange_response.getString("result");
            if (StringUtils.equals(result, "1")) {
                map.put("status", "ok");
                map.put("bizId", authParams.get("orderNum"));
                String  credits = integralChange_response.getString("balanceAmount");
                if(StringUtils.isBlank(credits)){
                    //查询会员积分
                    credits = getIntegralBalance(authParams.get("uid"));
                }
                LOG.info("地素 用户最新积分 credits={}", credits);
                //可用积分
                map.put("credits",credits);
            } else {
                map.put("status", "fail");
                String errorMsg = integralChange_response.getString("cause");
                ;
                if (StringUtils.isBlank(errorMsg)) {
                    errorMsg = "积分不足";
                }
                map.put("errorMessage", errorMsg);
                LOG.info("地素 新增/扣减积分失败，result={},errorMsg={}", result, errorMsg);
            }
        } catch (Exception e) {
            LOG.error("地素 新增/扣减积分接口解析错误:{}--是否新增:{}", body, addCredits, e);
            map.put("status", "fail");
            map.put("errorMessage", "地素新增/扣减积分解析结果错误");
        }
        LOG.info("地素加减积分定制返回，map={}", JSON.toJSONString(map));
        return JSONObject.toJSONString(map);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        Map<String, String> authParams = message.getAuthParams();
        appId = Long.valueOf(message.getAppId());
        HttpPost httpPost = new HttpPost(disuConfig.getDomain().concat(disuConfig.getIntegralChangeUrl()));
        List<NameValuePair> params = buildCommonCreditsParams(authParams, disuConfig.getAddCreditsType(), disuConfig.getAddCreditsChangeType(), appId);
        UrlEncodedFormEntity formEntity = null;
        try {
            formEntity = new UrlEncodedFormEntity(params, "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            LOG.error("地素 加积分请求错误:" + e.getMessage(), e);
            return null;
        }
        formEntity.setContentType("application/x-www-form-urlencoded");
        httpPost.setEntity(formEntity);
        LOG.info("地素 加积分，req={}", JSON.toJSONString(params));
        return httpPost;
    }

    public String getIntegralBalance(String unionid){
        // 准备参数
        List<NameValuePair> params = new ArrayList<>();
        params.add(new BasicNameValuePair("token", getToken(appId)));
        params.add(new BasicNameValuePair("entMicroSignal", disuConfig.getEntMicroSignal()));
        params.add(new BasicNameValuePair("unionid", unionid));
        String url = disuConfig.getDomain().concat(disuConfig.getIntegralBalanceUrl());
        LOG.info("地素，查询会员积分余额,请求url={},参数params={}，appId={}", url, JSON.toJSONString(params),appId);
        String resp = doPost(url, params);
        LOG.info("地素，查询会员积分余额,返回结果：" + resp);
        JSONObject repResponse = JSONObject.parseObject(resp);
        JSONObject integralBalance_response = repResponse.getJSONObject("integralBalance_response");
        String result = integralBalance_response.getString("result");
        if(!StringUtils.equals("14008",result)){
            LOG.info("地素，查询会员积分余额错误，unionId={},result={},cause={}",unionid,result,integralBalance_response.getString("cause"));
            return null;
        }
        JSONObject integralBalance = integralBalance_response.getJSONObject("integralBalance");
        String accumulatPoints = integralBalance.getString("accumulatPoints");
        return accumulatPoints;
    }

    /**
     * 发送str格式的post请求
     *
     * @return
     */
    public static String doPost(String url, List<NameValuePair> params){
        HttpClient httpClient = HttpClientBuilder.create().build();
        // 建立HttpPost对象
        HttpPost httppost = new HttpPost(url);
        try {
            UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(params, "UTF-8");
            formEntity.setContentType("application/x-www-form-urlencoded");
            httppost.setEntity(formEntity);

            // 发送Post,并返回一个HttpResponse对象
            HttpResponse response = httpClient.execute(httppost);
            return EntityUtils.toString(response.getEntity());
        } catch (Exception e) {
            LOG.error("地素 请求失败:" + e.getMessage(), e);
            return null;
        }
    }


    /**
     * 获取token
     *
     * @param appId
     * @return
     */
    public String getToken(Long appId) {
        //查询缓存中是否token还有效
        String token = advancedCacheClient.get(getTokenKey(appId));
        LOG.info("地素 从缓存中获取token={}", token);
        //无效则查询开发者的token，并且存入缓存中
        if (StringUtils.isBlank(token)) {
            return refreshToken(appId);
        }

        return token;
    }

    private String refreshToken(Long appId) {
        String token = null;
        try (RedisLock lock = redisAtomicClient.getLock(getTokenLock(appId), 5)) {
            if (lock == null) {
                LOG.info("地素 刷新token未获取到锁，等待一会儿再获取token");
                //获取不到锁的暂停下 再重新获取token
                TimeUnit.SECONDS.sleep(5);
                token = getToken(appId);
                return token;
            }
            token = advancedCacheClient.get(getTokenKey(appId));
            if (StringUtils.isNotBlank(token)) {
                return token;
            }
            JSONObject getToken_response = getGetTokenResponse();
            token = getToken_response.getString("token");
            if (StringUtils.isNotBlank(token)) {
                //刷到redis缓存中 开发者处令牌过期时间为1h 此处设置为50分钟
                advancedCacheClient.set(getTokenKey(appId), token, 50, TimeUnit.MINUTES);
            }
        } catch (Exception e) {
            LOG.warn("地素 刷新缓存失败", e);
        }

        return token;
    }

    private JSONObject getGetTokenResponse() throws Exception {
        String tokenUrl = disuConfig.getDomain().concat(disuConfig.getTokenUrl()).concat("?appKey=")
                .concat(disuConfig.getAppKey()).concat("&appSecret=").concat(disuConfig.getAppSecret());
        LOG.info("地素 tokenUrl:{}" ,tokenUrl);
        JSONObject response = JSONObject.parseObject(doGet(tokenUrl));
        LOG.info("地素 tokenResponse:{}" ,JSON.toJSONString(response));
        JSONObject getToken_response = response.getJSONObject("getToken_response");
        return getToken_response;
    }

    private static RequestConfig config = RequestConfig.custom()
            .setConnectionRequestTimeout(2000)
            .setConnectTimeout(2000)
            .setSocketTimeout(2000)
            .build();

    public static String doGet(String url) throws Exception {
        CloseableHttpClient httpclient = HttpClients.custom().setDefaultRequestConfig(config).build();
        CloseableHttpResponse response = null;
        try {
            HttpGet httpget = new HttpGet(url);
            response = httpclient.execute(httpget);
            if (response.getStatusLine().getStatusCode() == 200) {
                return EntityUtils.toString(response.getEntity(), "UTF-8");
            }
        } catch (Exception e) {
            LOG.error("地素 httpclient.doGet:{}" + e.getMessage(), url);
            throw e;
        } finally {
            try {
                if (null != response) {
                    response.close();
                }
            } catch (IOException e) {
                // LOG.error("httpclient.close:" + e.getMessage());
            }
        }
        return null;
    }

    private static String getTokenKey(Long appId) {
        return "disu_token_" + appId;
    }

    private static String getTokenLock(Long appId) {
        return "disu_token_lock_" + appId;
    }

}