package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.biz.credits.BaiduApi;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.tool.duiba.client.RequestLocal;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.config.RuXinConfig;
import cn.com.duiba.credits.sdk.SignTool;
import cn.com.duiba.dao.AppDAO;
import cn.com.duiba.domain.AppDO;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.enums.cebbank.CebBankTransCodeEnum;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.cloudapi.sdk.constant.HttpConstant;
import com.alibaba.cloudapi.sdk.enums.HttpConnectionModel;
import com.alibaba.cloudapi.sdk.enums.HttpMethod;
import com.alibaba.cloudapi.sdk.enums.ParamPosition;
import com.alibaba.cloudapi.sdk.enums.Scheme;
import com.alibaba.cloudapi.sdk.exception.SdkException;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.util.ApiRequestMaker;
import com.alibaba.cloudapi.sdk.util.HttpCommonUtil;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.net.URISyntaxException;
import java.util.*;

/**
 * @date:2022/4/26 17:20
 * @author:zhaozhanghai
 * @Description:
 */
@Service
public class RuxinApiStrategy implements ApiStrategy {
    private static Logger logger = LoggerFactory.getLogger(RuxinApiStrategy.class);
    @Autowired
    private RuXinConfig ruXinConfig;
    @Autowired
    private AppDAO appDAO;

    @Override
    public HttpRequestBase getMqSubCreditsHttpRequest(SubCreditsMsgWrapper message) {
        SubCreditsMsgDto subCreditsMsg = message.getSubCreditsMsg();
        Map<String, String> authParams = subCreditsMsg.getAuthParams();
        ApiRequest request = new ApiRequest(HttpMethod.GET, ruXinConfig.getDeductCredits());
        request.addParam("uid", authParams.get("uid"), ParamPosition.QUERY, true);
        request.addParam("credits", authParams.get("credits"), ParamPosition.QUERY, true);
        request.addParam("itemCode", authParams.get("itemCode"), ParamPosition.QUERY, false);
        request.addParam("appKey", authParams.get("appKey"), ParamPosition.QUERY, true);
        request.addParam("timestamp", authParams.get("timestamp"), ParamPosition.QUERY, true);
        request.addParam("description", authParams.get("description"), ParamPosition.QUERY, true);
        request.addParam("orderNum", authParams.get("orderNum"), ParamPosition.QUERY, true);
        request.addParam("type", authParams.get("type"), ParamPosition.QUERY, true);
        request.addParam("facePrice", authParams.get("facePrice"), ParamPosition.QUERY, false);
        request.addParam("actualPrice", authParams.get("actualPrice"), ParamPosition.QUERY, true);
        request.addParam("ip", authParams.get("ip"), ParamPosition.QUERY, false);
        request.addParam("qq", authParams.get("qq"), ParamPosition.QUERY, false);
        request.addParam("phone", authParams.get("phone"), ParamPosition.QUERY, false);
        request.addParam("alipay", authParams.get("alipay"), ParamPosition.QUERY, false);
        request.addParam("waitAudit", authParams.get("waitAudit"), ParamPosition.QUERY, false);
        request.addParam("params", authParams.get("params"), ParamPosition.QUERY, false);
        request.addParam("sign", authParams.get("sign"), ParamPosition.QUERY, true);
        requestHead(request);

        logger.info("ruxin-sub,query:{}",JSONObject.toJSONString(request.getQuerys()));

        return  buildRequest(request,Scheme.HTTP);
    }

    @Override
    public HttpRequestBase getAddCreditsMessageRequest(CreditsMessageDto message) {
        Map<String, String> authParams = message.getAuthParams();
        ApiRequest request = new ApiRequest(HttpMethod.GET, ruXinConfig.getAddCredits());
        String appKey = authParams.get("appKey");
        request.addParam("appKey", appKey, ParamPosition.QUERY, true);
        String uid = authParams.get("uid");
        String credits = authParams.get("credits");
        String type = authParams.get("type");
        String orderNum = authParams.get("orderNum");
        String subOrderNum = authParams.get("subOrderNum");
        String timestamp = authParams.get("timestamp");
        String description = authParams.get("description");
        String ip = authParams.get("ip");
        AppDO appDO = appDAO.getAppByCache(Long.valueOf(message.getAppId()));

        Map<String, String> param = new HashMap<>();
        param.put("appKey",appKey);
        param.put("uid", uid);
        param.put("credits",credits);
        param.put("type", type);
        param.put("orderNum", orderNum);
        param.put("subOrderNum", subOrderNum);
        param.put("timestamp", timestamp);
        param.put("description", description);
        param.put("ip", ip);
        param.put("appSecret",appDAO.getAppSecret(appDO));
        String sign = SignTool.sign(param);

        param.put("sign", sign);
        param.remove("appSecret");

        request.addParam("ip", ip, ParamPosition.QUERY, false);
        request.addParam("uid", uid, ParamPosition.QUERY, true);
        request.addParam("credits", credits, ParamPosition.QUERY, true);
        request.addParam("type", type, ParamPosition.QUERY, true);
        request.addParam("orderNum", orderNum, ParamPosition.QUERY, true);
        request.addParam("subOrderNum", subOrderNum, ParamPosition.QUERY, false);
        request.addParam("timestamp", timestamp, ParamPosition.QUERY, true);
        request.addParam("description", description, ParamPosition.QUERY, false);
        request.addParam("sign", sign, ParamPosition.QUERY, true);
        requestHead(request);

        logger.info("ruxin-add,query:{}",JSONObject.toJSONString(request.getQuerys()));


        return  buildRequest(request,Scheme.HTTP);
    }

    private void requestHead(ApiRequest request) {
        String currentEnv = SpringEnvironmentUtils.getCurrentEnv();
        //非生产环境 需要加上请求头
        if (!Objects.equals(currentEnv,SpringEnvironmentUtils.PROD)){
            request.addParam("X-Ca-Stage",ruXinConfig.getRequestHeader(),ParamPosition.HEAD,true);

        }
    }

    @Override
    public HttpRequestBase getRequestNotify(String notifyUrl, NotifyQueueDO record) {


        ApiRequest request = new ApiRequest(HttpMethod.GET,  ruXinConfig.getExchangeResult());
        AppDO appDO = appDAO.getAppByCache(record.getAppId());
        Map<String, String> param = new HashMap<>();
        String appKey = appDO.getAppKey();
        String orderNum = String.valueOf(record.getRelationId());
        String timestamp = String.valueOf(System.currentTimeMillis());
        String partnerUserId = record.getPartnerUserId();
        String success = record.getResult().toString();
        String developerBizId = record.getDeveloperBizId();
        String error4developer = record.getError4developer();
        if (Objects.isNull(error4developer)){
            error4developer="";
        }
        if (Objects.isNull(developerBizId)){
            developerBizId="";
        }
        String appSecret = appDAO.getAppSecret(appDO);

        param.put("uid", partnerUserId);
        param.put("appKey", appKey);
        param.put("orderNum", orderNum);
        param.put("timestamp", timestamp);
        param.put("success", success);
        param.put("bizId", developerBizId);
        param.put("errorMessage", error4developer);
        param.put("appSecret", appSecret);
        String sign = SignTool.sign(param);
        param.put("sign", sign);
        param.remove("appSecret");

        request.addParam("appKey",appKey, ParamPosition.QUERY, true);
        request.addParam("timestamp", timestamp, ParamPosition.QUERY, true);
        request.addParam("uid",partnerUserId, ParamPosition.QUERY, true);
        request.addParam("success", success, ParamPosition.QUERY, true);
        request.addParam("errorMessage", error4developer, ParamPosition.QUERY, false);
        request.addParam("orderNum", orderNum, ParamPosition.QUERY, true);
        request.addParam("bizId", developerBizId, ParamPosition.QUERY, false);
        request.addParam("sign",sign, ParamPosition.QUERY, true);
        requestHead(request);

        logger.info("ruxin-notify,query:{}",JSONObject.toJSONString(request.getQuerys()));

        return  buildRequest(request,Scheme.HTTP);

    }



    @Override
    public HttpRequestBase getOrderStatusPushHttp(HttpMessageDO db, HttpRequestMessageDto msg, AppDO app) {
        ApiRequest request = new ApiRequest(HttpMethod.POST_BODY, ruXinConfig.getPushOrder());
        Map<String, String> map = msg.getHttpParams();
        if (MapUtils.isEmpty(map)) {
            return null;
        }
        map.put("appKey", app.getAppKey());
        map.put("appSecret", appDAO.getAppSecret(app));
        String sign = SignTool.sign(map);
        map.put("sign", sign);
        map.remove("appSecret");
        request.setBody(JSONObject.toJSONString(map).getBytes());
        requestHead(request);

        return  buildRequest(request, Scheme.HTTPS);
    }

    private HttpRequestBase buildRequest(ApiRequest apiRequest, Scheme scheme) {
        if(apiRequest.getHttpConnectionMode() == HttpConnectionModel.SINGER_CONNECTION){
            apiRequest.setHost(ruXinConfig.getHost());
            apiRequest.setScheme(scheme);
        }

        ApiRequestMaker.make(apiRequest , ruXinConfig.getAliyunAppKey() ,ruXinConfig.getAliyunAppSecret());
        RequestBuilder builder = RequestBuilder.create(apiRequest.getMethod().getValue());

        /*
         *  拼接URL
         *  HTTP + HOST + PATH(With pathparameter) + Query Parameter
         */
        try {
            URIBuilder uriBuilder = new URIBuilder();
            uriBuilder.setScheme(apiRequest.getScheme().name());
            uriBuilder.setHost(apiRequest.getHost());
            uriBuilder.setPath(apiRequest.getPath());
            if (!HttpCommonUtil.isEmpty(apiRequest.getQuerys())) {
                for (Map.Entry<String, List<String>> entry : apiRequest.getQuerys().entrySet()) {
                    for(String value : entry.getValue()){
                        uriBuilder.addParameter(entry.getKey(), value);
                    }

                }
            }
            builder.setUri(uriBuilder.build());
        } catch (URISyntaxException e) {
            throw new SdkException("build http request uri failed", e);
        }

        EntityBuilder bodyBuilder = EntityBuilder.create();

        //设置请求数据类型
        if(null == apiRequest.getFirstHeaderValue(HttpConstant.CLOUDAPI_HTTP_HEADER_CONTENT_TYPE)) {
            bodyBuilder.setContentType(ContentType.parse(apiRequest.getMethod().getRequestContentType()));
        }
        else{
            bodyBuilder.setContentType(ContentType.parse(apiRequest.getFirstHeaderValue(HttpConstant.CLOUDAPI_HTTP_HEADER_CONTENT_TYPE)));
        }


        if (!HttpCommonUtil.isEmpty(apiRequest.getFormParams())) {
            /*
             *  如果formParams不为空
             *  将Form中的内容以urlQueryParams的格式存放在body中(k1=v1&k2=v2&k3=v3)
             */
            List<NameValuePair> paramList = new ArrayList<NameValuePair>();

            for (Map.Entry<String, List<String>> entry : apiRequest.getFormParams().entrySet()) {
                for(String value : entry.getValue()) {
                    paramList.add(new BasicNameValuePair(entry.getKey(), value));
                }
            }
            bodyBuilder.setParameters(paramList);
            builder.setEntity(bodyBuilder.build());
        } else if (!HttpCommonUtil.isEmpty(apiRequest.getBody())) {
            bodyBuilder.setBinary(apiRequest.getBody());
            builder.setEntity(bodyBuilder.build());
        }

        for (Map.Entry<String, List<String>> entry : apiRequest.getHeaders().entrySet()) {
            for(String value : entry.getValue()){
                builder.addHeader(entry.getKey(), value);
            }
        }

        return (HttpRequestBase)builder.build();
    }
}
