package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.domain.SupplierRequest;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/**
 * @Date 2020/12/28
 * @Created by cmm
 */
@Service
public class ZhilianApiStrategy implements ApiStrategy {

    private static final Logger LOGGER = LoggerFactory.getLogger(ZhilianApiStrategy.class);

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        try {
            if(StringUtils.isNotBlank(body)){
                JSONObject responseJson = JSONObject.parseObject(body);
                String data = responseJson.getString("data");
                if(StringUtils.isBlank(data)){
                    return body;
                }
                return data;
            }

            return body;
        } catch (Exception e) {
            LOGGER.info("[智联招聘]解析虚拟商品兑换请求结果异常 orderId=" + request.getOrderId(), e);
            return body;
        }
    }
}
