package cn.com.duiba.biz.credits.strategy.Impl;

import cn.com.duiba.api.tools.RandomCodeUtil;
import cn.com.duiba.biz.credits.strategy.ApiStrategy;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.config.ZhongXinConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.wolf.utils.DateUtils;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.citic.openbank.sdk.CiticSdk;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author MeiChang
 * @Description
 */

@Service
public class ZhongXinApiStrategy implements ApiStrategy {
    private static final Logger log = LoggerFactory.getLogger(ZhongXinApiStrategy.class);

    public static final SimpleDateFormat format = new SimpleDateFormat("HHmmss");

    @Autowired
    private ZhongXinConfig zhongXinConfig;

    private final String DEFAULT_CHARSET = "UTF-8";

    private  RequestConfig config;

    private static CiticSdk sdk = new CiticSdk();

    @PostConstruct
    public void init(){
        try{
            // 设置发送请求秘钥
            sdk.setPublicKeyEncryptUseStr(zhongXinConfig.getReqPublikey());
            sdk.setPrivateKeySignatureWithPwdUseStr(zhongXinConfig.getRepPrivatekey(), zhongXinConfig.getRepPrivatekeyPwd());

            // 设置接受响应秘钥
            sdk.setPublicKeyValidateSignatureUseStr(zhongXinConfig.getRespPublikey());
            sdk.setPrivateKeyDecryptWithPwdUseStr(zhongXinConfig.getRespPrivatekey(),zhongXinConfig.getRespPrivatekeyPwd());
            // 设置解码编码
            sdk.setTransferEncode("utf-8");
            //http请求超时配置
            config = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(5000).setConnectionRequestTimeout(1000).build();
            // 注册具体策略
            ApiStrategyRouter.register(zhongXinConfig.getAppIds(), this);
        }catch (Exception e){
            log.error("[中信银行]初始化SDK失败：" , e);
        }
    }


    @Override
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        log.info("中信银行虚拟商品请求, request={}", JSON.toJSONString(request));
        String url = request.getHttpUrl();
        String paramsStr = url.substring(url.indexOf('?') + 1);
        Map<String, String> authParams = AssembleTool.getUrlParams(paramsStr);
        String goodsNum = authParams.get("params");
        String uid = authParams.get("uid");
        String httpUrl = UrlUtils2.extractUrl(request.getHttpUrl());
        HttpPost httpPost = new HttpPost(httpUrl);
        Date date = new Date();
        String HHmmss ="";
        synchronized (format) {
            HHmmss = ZhongXinApiStrategy.format.format(date);
        }
        Map<String, String> requestData = new HashMap();
        requestData.put("OPENVER", "1.0.0");//开放平台接口版本号 默认1.0.0
        requestData.put("OPENTRANSCODE", "IFQYE002");//开放平台接口码
        requestData.put("OPENMERCODE", zhongXinConfig.getAppId());
        requestData.put("OPENMERNAME", zhongXinConfig.getMerchantName());
        requestData.put("OPENBUSITYPE", zhongXinConfig.getType());//开放平台业务类型（由开放银行维护后提供）
        requestData.put("OPENLAUNCHDATE", String.valueOf(DateUtils.getDayNumber(date)));//商户交易发起日期
        requestData.put("OPENLAUNCHTIME", HHmmss);//商户交易发起时间
        requestData.put("OPENMERFLOWID", DateUtils.getMillisecond()+RandomCodeUtil.getNumCode(37));//商户请求流水号
        //end公共标签域

        requestData.put("BUZYTYPE", "C001");
        requestData.put("CHANNELID", "01");
        requestData.put("CSTINFVALUE", uid);
        requestData.put("SERNUM", request.getOrderId());
        requestData.put("BATCHID", goodsNum);
        //end业务标签域
        try {
            String businessJsonStr = JSON.toJSONString(requestData);
            //注意businessJsonStr是JSON字符串
            //得到加密信息
            String encryptBody = sdk.encryptBusiness(businessJsonStr);
            //处理明文数据：去掉换行符
            businessJsonStr=businessJsonStr.replaceAll("\r|\n", "");
            //转化为jsonobject
            JSONObject jsonObject = JSONObject.parseObject(businessJsonStr);
            //对报文中的key字段进行ASCII排序
            StringBuffer stringBuffer = sortJSONObject(jsonObject);
            businessJsonStr = stringBuffer.toString().replaceAll("\\}\\{", "\\},\\{");
            //得到签名信息
            String sign = sdk.signature(businessJsonStr);

            JSONObject params = new JSONObject();
            params.put("transType","normal");
            params.put("encryptBody",encryptBody);
            params.put("sign",sign);
            StringEntity stringEntity = new StringEntity(params.toJSONString(), DEFAULT_CHARSET);
            stringEntity.setContentEncoding(DEFAULT_CHARSET);
            stringEntity.setContentType("application/json");
            log.info("中信银行虚拟商品请求, stringEntity={}", JSON.toJSONString(requestData, SerializerFeature.PrettyFormat));
            httpPost.setEntity(stringEntity);
            // 设置超时重试
            httpPost.setConfig(config);
            return httpPost;
        }catch (Exception e){
            log.error("[中信银行]虚拟商品兑换请求生成失败 orderId=" + request.getOrderId(), e);
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getVirtualResponse(SupplierRequest request, String body) {
        log.info("中信银行虚拟商品响应, result={}", JSON.toJSONString(body, SerializerFeature.PrettyFormat));
        JSONObject result = new JSONObject();
        try {
            String realRespJson = sdk.validateSignature(body);
            log.info("中信银行虚拟商品响应, body={}", JSON.toJSONString(realRespJson));
            JSONObject jsonObject = JSONObject.parseObject(realRespJson);
            String status = (String)jsonObject.get("STATUS");
            if (Objects.equals(status, "1")) {
                result.put("status", "success");
            }else {
                result.put("status", "fail");
            }
            result.put("supplierBizId",request.getOrderId());
        } catch (Exception e) {
            result.put("status", "fail");
            result.put("errorMessage", e.getMessage());
            log.error("[中信银行]解析虚拟商品兑换请求结果异常 orderId=" + request.getOrderId(), e);
        }
        return result.toJSONString();
    }


    /**
     * 针对要签名验签的内容做ASCII排序
     * @param jsonObject
     * @return
     */
    public StringBuffer sortJSONObject(JSONObject jsonObject) {
        if (jsonObject == null) {
            return null;
        }
        StringBuffer plain = new StringBuffer();
        @SuppressWarnings("unchecked")
        List<Map.Entry<String, Object>> infolds = new ArrayList<Map.Entry<String, Object>>(
                jsonObject.entrySet());

        //ASCII 排序（字典序）
        Collections.sort(infolds, new Comparator<Map.Entry<String, Object>>() {
            @Override
            public int compare(Map.Entry<String, Object> o1, Map.Entry<String, Object> o2) {
                return (o1.getKey().compareTo(o2.getKey()));
            }
        });
        plain.append("{");
        for (Map.Entry<String, Object> item : infolds) {
            String key = item.getKey();
            if ("commonDataList".equalsIgnoreCase(key)) {
                continue;
            }
            plain.append("\"" + key + "\"");
            plain.append(":");
            Object val = item.getValue();
            if (val instanceof JSONObject) {
                StringBuffer str = sortJSONObject((JSONObject) val);
                plain.append(str);
            } else if (val instanceof String) {
                plain.append("\"" + val + "\"");
            } else if (val instanceof JSONArray) {
                plain.append("[");
                JSONArray arr = (JSONArray) val;
                for (int i = 0; i < arr.size(); i++) {
                    StringBuffer tempstr = new StringBuffer();
                    Object obj = arr.get(i);
                    if (obj instanceof JSONObject) {
                        tempstr = sortJSONObject((JSONObject) obj);
                    }
                    plain.append(tempstr);
                }
                plain.append("]");
            }
            plain.append(",");
        }
        plain.delete(plain.length() - 1, plain.length());
        if (plain.length() > 0) {
            plain.append("}");
        }
        return plain;
    }
}
