package cn.com.duiba.constant;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @program: thirdparty-all
 * @description: 光大银行配置
 * @author: Simba
 * @create: 2020-02-18 16:05
 **/
@Configuration
@ConfigurationProperties(prefix = "ceb.bank")
public class CebBankConfig {

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet;

    /**
     * 实物发奖通知接口url
     */
    private String objectNotifyUrl;

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getObjectNotifyUrl() {
        return objectNotifyUrl;
    }

    public void setObjectNotifyUrl(String objectNotifyUrl) {
        this.objectNotifyUrl = objectNotifyUrl;
    }
}

