package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.CgwsApiStrategy;
import com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * 长城证券
 * @author chenzhenxing
 * @date 2021/12/10 5:23 下午
 */
@Configuration
@ConfigurationProperties(prefix = "changcheng.security")
public class CgwsConfig implements InitializingBean {

    private static final Logger LOGGER = LoggerFactory.getLogger(CgwsApiStrategy.class);

    @Autowired
    private CgwsApiStrategy cgwsApiStrategy;

    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(86853L);

    private String url = "https://devfintech.cgws.com:8443/api/business-credit-mall/h5/a/duiba/record";


    public CgwsApiStrategy getCgwsApiStrategy() {
        return cgwsApiStrategy;
    }

    public void setCgwsApiStrategy(CgwsApiStrategy cgwsApiStrategy) {
        this.cgwsApiStrategy = cgwsApiStrategy;
    }

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        LOGGER.info("长城证券开始注册策略---------");
        ApiStrategyRouter.register(appIdSet, cgwsApiStrategy);
    }
}
