package cn.com.duiba.constant;

import cn.com.duiba.api.bo.custom.funheadlines.FunheadLinesAppMapping;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 趣头条-配置文件
 * @Author: fxr
 * @Date: 2019/4/1
 */
@Configuration
@RefreshScope
public class FunHeadlinesConfig {

    private static final Logger LOGGER = LoggerFactory.getLogger(FunHeadlinesConfig.class);
    /**
     * 兑吧-在趣头条的应用AppKey
     */
    @Value("${app.funheadlines.funheadLinesAppMappingStr}")
    private String funheadLinesAppMappingStr;

    /**
     * 趣头条-appid
     */
    @Value("${app.funheadlines.appId}")
    private String appId;


    private List<FunheadLinesAppMapping> funheadLinesAppMappingList;

    private List<Long> appIdList;

    public List<Long> getAppIds() {

        if (StringUtils.isBlank(appId)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(appIdList)) {
            appIdList = Arrays.stream(appId.split(",")).map(Long::valueOf).collect(Collectors.toList());
        }
        return appIdList;
    }

    /**
     * 根据APPID获取映射配置
     *
     * @param appId
     * @return
     */
    public FunheadLinesAppMapping getFunheadLinesAppMappingByAppId(String appId) {
        return getFunheadLinesAppMappingList(funheadLinesAppMappingStr).stream().filter(v -> v.getAppId().equals(appId)).findFirst().orElse(null);
    }

    private List<FunheadLinesAppMapping> getFunheadLinesAppMappingList(String funheadLinesAppMappingStr) {
        if (org.apache.commons.lang.StringUtils.isBlank(funheadLinesAppMappingStr)) {
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(funheadLinesAppMappingList)) {
            try {
                funheadLinesAppMappingList = JSONObject.parseArray(this.funheadLinesAppMappingStr, FunheadLinesAppMapping.class);
            } catch (Exception e) {
                LOGGER.error("[FunHeadlinesConfig-getFunheadLinesAppMappingList]趣头条-配置解析错误:funheadLinesAppMappingStr：{}", funheadLinesAppMappingStr, e);
                return Collections.emptyList();
            }
        }
        return funheadLinesAppMappingList;
    }
}

