package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Set;

/**
 * @author: pengyi
 * @description: 发起请求之前异常，可不用发起http请求配置
 * @date: 2021/9/13 上午10:26
 */
@Configuration
@ConfigurationProperties(prefix = "not.request")
public class NotRequestConfig {

    private Set<Long> appIds = Sets.newHashSet(19592L);

    private String errorMessage = "扣积分请求发前异常，未发起http请求";

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public boolean verifyAppId(Long appId) {
        if (appId == null) {
            return false;
        }
        return appIds.contains(appId);
    }
}
