package cn.com.duiba.constant;

import com.google.common.collect.Sets;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.Set;

@Configuration
@ConfigurationProperties(prefix = "skip.nofity")
public class SkipNotifyConfig {
    /**
     * 应用id集合
     */
    private Set<Long> appIdSet = Sets.newHashSet(-1L);

    /**
     * 成功时不通知appid集合
     */
    private Set<Long> successAppIds = Collections.emptySet();

    /**
     * 失败时不通知appid集合
     */
    private Set<Long> failedAppIds = Collections.emptySet();

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public boolean hasNotNotify(Long appId, Boolean result) {
        if (appId == null || result == null) {
            return true;
        }
        return hasNotNotify(appId) || (result && hasSuccessNotNotify(appId)) || (!result && hasFailedNotNotify(appId));
    }

    public boolean hasNotNotify(Long appId) {
        if(CollectionUtils.isEmpty(appIdSet)){
            return false;
        }

        return appIdSet.contains(appId);
    }

    public Set<Long> getSuccessAppIds() {
        return successAppIds;
    }

    public void setSuccessAppIds(Set<Long> successAppIds) {
        this.successAppIds = successAppIds;
    }

    public Set<Long> getFailedAppIds() {
        return failedAppIds;
    }

    public void setFailedAppIds(Set<Long> failedAppIds) {
        this.failedAppIds = failedAppIds;
    }

    /**
     * 是否成功时不通知
     * @param appId
     * @return
     */
    public boolean hasSuccessNotNotify(Long appId) {
        return CollectionUtils.isNotEmpty(successAppIds) && successAppIds.contains(appId);
    }

    /**
     * 是否失败时不通知
     * @param appId
     * @return
     */
    public boolean hasFailedNotNotify(Long appId) {
        return CollectionUtils.isNotEmpty(failedAppIds) && failedAppIds.contains(appId);
    }
}
