package cn.com.duiba.constant;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.google.common.collect.Maps;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.Map;
import java.util.Set;

/**
 * @author haojiahong
 * @date 2020-06-23
 */
@Configuration
@ConfigurationProperties(prefix = "wufangzhai")
public class WuFangZhaiConfig {

    private Set<Long> appIds;


    private String url;
    private String clientId;
    private String clientSecret;
    private String grantType;
    private String scope;
    private String username;
    private String password;

    private String config;

    private Map<String, Config> configMap= Maps.newHashMap();

    public String getConfig() {
        return config;
    }

    public void setConfig(String config) {
        this.config = config;
        Map<String, Config> configMap = JSON.parseObject(config, new TypeReference<Map<String, Config>>(){});
        this.configMap = configMap;
    }

    public Config getConfigByAppIdIfNullThrowEx(String appId) {
        Config config = configMap.get(appId);
        if (config == null) {
            throw new ThirdpatyException("该appId没有对应的配置");
        }
        return config;
    }

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getGrantType() {
        return grantType;
    }

    public void setGrantType(String grantType) {
        this.grantType = grantType;
    }

    public String getScope() {
        return scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public enum Api {
        GET_TOKEN("/oauth/token"),
        CARD_QUERY_INFO("/card/queryInfoByStr"),
        TRADE_REDUCE_INTEGRAL("/trade/reduceIntegral"),
        TRADE_AWARD_INTEGRAL("/trade/awardIntegral"),
        COUPON_SEND_COUPON("/coupon/sendCoupon");

        String path;

        Api(String path) {
            this.path = path;
        }

        public String getPath() {
            return path;
        }

        public String getApiAbsolutePath(WuFangZhaiConfig config) {
            return config.getUrl() + this.getPath();
        }
    }
    public static class Config{
        private String username;
        private String password;

        public String getUsername() {
            return username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}
