package cn.com.duiba.constant.kouweiwang;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.kouweiwang.KwwApiStrategy;
import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.Set;


/**
 * 口味王配置
 *
 * @author fja
 * <p>
 * 测试uid: 5246114304382300
 */
@Configuration
@ConfigurationProperties(prefix = "kww")
public class KwwConfig implements InitializingBean {

    @Resource
    private KwwApiStrategy kwwApiStrategy;

    /**
     * aes key的长度
     */
    private final static int AES_KEY_LENGTH = 1 << 4;

    /**
     * 补位数组
     */
    private final static byte[] PLUS_BYTES = {0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f};



    private Set<Long> appIdSet = Sets.newHashSet(-1L);

    /**
     * 系统接入标识appId
     */
    private String kwwAppId = "fe58098190012a428cbb9c1cf7d2f693";

    /**
     * 秘钥
     */
    private String kwwAppSecret = "5a456ae9ddd3a74b3ae8e17202dc1a5a";


    private byte[] aesKey;


    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getKwwAppId() {
        return kwwAppId;
    }

    public void setKwwAppId(String kwwAppId) {
        this.kwwAppId = kwwAppId;
    }

    public String getKwwAppSecret() {
        return kwwAppSecret;
    }

    public void setKwwAppSecret(String kwwAppSecret) {
        this.kwwAppSecret = kwwAppSecret;
    }

    public byte[] getAesKey() {
        return aesKey;
    }

    @Override
    public void afterPropertiesSet() throws BizException {
        ApiStrategyRouter.register(appIdSet, kwwApiStrategy);

        //生成aes key
        this.aesKey = genAesKey();
    }


    /**
     * 生成aes key，密钥长度不足需要补位
     *
     * @return aes key
     * @throws BizException 配置异常
     */
    private byte[] genAesKey() throws BizException {
        if (StringUtils.isBlank(kwwAppSecret)) {
            throw new BizException("appSecret为空，检查apollo配置，namespace=kww，key=kww.kwwAppSecret");
        }

        //秘钥需要补多少字符
        int plus = AES_KEY_LENGTH - kwwAppSecret.length();

        byte[] secretBytes = kwwAppSecret.getBytes(StandardCharsets.UTF_8);
        byte[] aesKey = new byte[AES_KEY_LENGTH];

        for (int i = 0; i < AES_KEY_LENGTH; i++) {
            if (secretBytes.length > i) {
                aesKey[i] = secretBytes[i];
            } else {
                aesKey[i] = PLUS_BYTES[plus];
            }
        }

        return aesKey;
    }
}
