package cn.com.duiba.domain;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by fangdong on 2018/10/17
 */
public class ConsumerCreditsLogDO implements Serializable {
    private static final long serialVersionUID = -7635957706404227711L;

    /**
     * id
     */
    private Long id;

    /**
     * consumerId
     */
    private Long consumerId;

    /**
     * 应用id
     */
    private Long appId;

    /**
     * 订单号
     */
    private String orderNum;

    /**
     * 开发者的订单号(唯一且不重复，如果失败情况，该值可以不传)
     */
    private String developerBizId;

    /**
     * 订单业务类型，兑换类型：alipay(支付宝), qb(Q币), coupon(优惠券), object(实物), phonebill(话费), phoneflow(流量),
     * virtual(虚拟商品),game(游戏), hdtool(活动抽奖),sign(签到)，reSign(补签)所有类型不区分大小写
     */
    private String bizType;

    /**
     * 业务id
     */
    private String bizId;

    /**
     * 关联业务类型
     */
    private String relationType;

    /**
     * 关联业务id
     */
    private String relationId;

    /**
     * 变动类型，1：消耗，2：增加
     */
    private Integer changeType;

    /**
     * 状态，1：失败，2：成功
     */
    private Integer logStatus;

    /**
     * 积分数量
     */
    private Long credits;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 描述
     */
    private String description;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public String getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(String orderNum) {
        this.orderNum = orderNum;
    }

    public String getDeveloperBizId() {
        return developerBizId;
    }

    public void setDeveloperBizId(String developerBizId) {
        this.developerBizId = developerBizId;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public String getBizId() {
        return bizId;
    }

    public void setBizId(String bizId) {
        this.bizId = bizId;
    }

    public Integer getChangeType() {
        return changeType;
    }

    public void setChangeType(Integer changeType) {
        this.changeType = changeType;
    }

    public Long getCredits() {
        return credits;
    }

    public void setCredits(Long credits) {
        this.credits = credits;
    }

    public Date getOrderTime() {
        return orderTime;
    }

    public void setOrderTime(Date orderTime) {
        this.orderTime = orderTime;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getLogStatus() {
        return logStatus;
    }

    public void setLogStatus(Integer logStatus) {
        this.logStatus = logStatus;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRelationType() {
        return relationType;
    }

    public void setRelationType(String relationType) {
        this.relationType = relationType;
    }

    public String getRelationId() {
        return relationId;
    }

    public void setRelationId(String relationId) {
        this.relationId = relationId;
    }

    @Override
    public String toString() {
        return "ConsumerCreditsLogDO{" +
                "id=" + id +
                ", consumerId=" + consumerId +
                ", appId=" + appId +
                ", orderNum='" + orderNum + '\'' +
                ", developerBizId='" + developerBizId + '\'' +
                ", bizType='" + bizType + '\'' +
                ", bizId='" + bizId + '\'' +
                ", relationType='" + relationType + '\'' +
                ", relationId='" + relationId + '\'' +
                ", changeType=" + changeType +
                ", logStatus=" + logStatus +
                ", credits=" + credits +
                ", orderTime=" + orderTime +
                ", description='" + description + '\'' +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
