package cn.com.duiba.enums.icbcelife;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

public enum IcbcElifeActNameEnum {
//    3-欢趣派对 4-欢趣竞猜 5-欢趣竞拍 6-欢趣市集 7-欢趣农场

    PAI_DUI("3","欢趣派对"),
    JING_CAI("4","欢趣竞猜"),
    JING_PAI("5","欢趣竞拍"),
    SHI_JI("6","欢趣市集"),
    NONG_CHANG("7","欢趣农场"),
    ;

    private String code;
    private String name;

    private static final ImmutableMap<String, IcbcElifeActNameEnum> ALL_MAPPING;

    static {
        Map<String, IcbcElifeActNameEnum> temp = Maps.newHashMap();
        for (IcbcElifeActNameEnum value : values()) {
            temp.put(value.name, value);
        }
        ALL_MAPPING = ImmutableMap.copyOf(temp);
    }

    @CheckForNull
    public static IcbcElifeActNameEnum getByName(String name) {
        return ALL_MAPPING.get(name);
    }

    IcbcElifeActNameEnum(String code,String name){
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


}
