package cn.com.duiba.enums.wanda;

/**
 * 万达酒店专用错误码集合
 *
 * @author fja
 * @since 2021-04-20
 */
public enum WandaErrorCode {
    /**
     * 授权失败，未知异常
     */
    E1000000("1000000", "授权失败，未知异常"),
    /**
     * 授权失败，接口返回异常
     */
    E1000001("1000001", "授权失败，接口返回异常"),
    /**
     * accessToken获取失败
     */
    E1000002("1000002","授权失败，accessToken获取失败"),
    /**
     * 查询用户积分失败
     */
    E1000003("1000003","查询用户积分失败，responseDomain为空"),
    ;
    /**
     * 错误码
     */
    private final String errorCode;
    /**
     * 错误描述
     */
    private final String errorMsg;

    WandaErrorCode(String errorCode, String errorMsg) {
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public String getErrorCode() {
        return errorCode;
    }

    public String getErrorMsg() {
        return errorMsg;
    }
}
