package cn.com.duiba.remoteimpl;

import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.api.rcb.RemoteReconcileService;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RestController;

/**
 * Created by xutao on 2020/6/9.
 */
@RestController
public class RemoteReconcileServiceImpl implements RemoteReconcileService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteReconcileServiceImpl.class);

    @Autowired
    private ReconciliationBizService reconciliationService;

    @Autowired
    private ReconciliationRecordService reconciliationRecordService;

    @Override
    public void mallExchangeNotify(ReconciliationRecordDto reconciliationRecordDto) {
        LOGGER.info("对账普兑通知，reconciliationRecordDto:{}", JSON.toJSON(reconciliationRecordDto));
        reconciliationService.mallExchangeNotify(reconciliationRecordDto);
    }

    @Override
    public Integer updateMallOrderStatus(ReconciliationRecordDto reconciliationRecordDto) {
        LOGGER.info("更新对账普兑状态，reconciliationRecordDto:{}", JSON.toJSON(reconciliationRecordDto));
        return reconciliationRecordService.updateMallOrderStatus(reconciliationRecordDto);
    }
}
