package cn.com.duiba.remoteimpl.tailong;

import cn.com.duiba.constant.TailongBankConfig;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.api.tailong.RemoteTaiLongService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zjtlcb.fcloud.utils.MD5Util;
import com.zjtlcb.fcloud.utils.SM2Util;
import com.zjtlcb.fcloud.utils.SM3Util;
import com.zjtlcb.fcloud.utils.SM4Util;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

/**
 * @description:
 * @author: cxh
 * @date: 2021-07-20 19:16
 */
@RestController
public class RemoteTaiLongServiceImpl implements RemoteTaiLongService {

    private static final Logger log = LoggerFactory.getLogger(cn.com.duiba.remoteimpl.tailong.RemoteTaiLongServiceImpl.class);

    @Resource(name = "redisTemplate")
    private RedisTemplate<String, String> redisTemplate;
    @Autowired
    private TailongBankConfig tailongBankConfig;
    @Autowired
    HttpAsyncClientPool httpAsyncClientPool;



    public String getCustomVirtualResult(Map<String, String> paramMap, Map<String, String> headerMap, String serviceId){
        HttpRequestBase httpRequestBase = getHttpRequestBase(paramMap, headerMap, serviceId);
        HttpClient httpClient = HttpClientBuilder.create().build();
        try {
            HttpResponse httpResponse = httpClient.execute(httpRequestBase);
            String result = EntityUtils.toString(httpResponse.getEntity());
            return getResponseNotify(result);
        } catch (Exception e){
            log.error("泰隆银行调用mmsTaskGrant交易码异常",e);
        }

        return null;
    }

    @Override
    public String getProjectId(String body) {
        JSONObject reqJsonObj = JSON.parseObject(body);
        JSONObject decrypt = decrypt(reqJsonObj);
        return decrypt == null? null : decrypt.toJSONString();
    }


    private HttpRequestBase getHttpRequestBase(Map<String, String> paramMap, Map<String, String> headMap, String serviceId) {
        JSONObject reqMsg = new JSONObject();
        Map<String, Object> map = new HashMap<String, Object>();
        map.put("head", headMap);
        map.put("body", paramMap);
        reqMsg.put("reqData", JSON.toJSON(map));
        reqMsg.put("appID", tailongBankConfig.getMechAppID());
        reqMsg.put("seqNO", (new SimpleDateFormat("yyyyMMddHHmmsss")).format(new Date()));
        reqMsg.put("signMethod", "SM3");
        reqMsg.put("encryptMethod", "SM4");
        reqMsg.put("appAccessToken", this.getTLToken());
        log.info("泰隆银行调用服务：" + tailongBankConfig.getTlHttpUrl() + serviceId + "   原请求报文：" + reqMsg.toJSONString());
        String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
        HttpPost httpPost = null;
        try {
            reqMsg.put("sm2EncryptData", SM2Util.encryptByPublicKey(randomKey, tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", SM2Util.signByPrivateKey(randomKey, tailongBankConfig.getSm2PrivateKey(), tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", SM3Util.sign(reqMsg.getString("reqData") + reqMsg.getString("seqNO") + tailongBankConfig.getAppSecretKey() + randomKey));
            reqMsg.put("reqData", SM4Util.encrypt(reqMsg.getString("reqData"), reqMsg.getString("seqNO") + reqMsg.getString("appAccessToken") + tailongBankConfig.getAppSecretKey() + randomKey));
            httpPost = new HttpPost(tailongBankConfig.getTlHttpUrl() + serviceId);
            ByteArrayEntity bae = new ByteArrayEntity(reqMsg.toJSONString().getBytes());
            httpPost.setEntity(bae);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        } catch (Exception e) {
            log.warn("泰隆银行 getHttpRequestBase",e);
        }
        return httpPost;
    }



    //获取请求接口用的accesstoken
    private String getTLToken() {
        String appAccessToken = redisTemplate.opsForValue().get(tailongBankConfig.getAccessTokenRedisKey());
        if (StringUtils.isNotBlank(appAccessToken)) {
            return appAccessToken;
        }
        try {
            JSONObject reqMsg = new JSONObject();
            String seqNO = (new SimpleDateFormat("yyyyMMddHHmmsss")).format(new Date());
            reqMsg.put("appID", tailongBankConfig.getMechAppID());
            reqMsg.put("seqNO", seqNO);
            reqMsg.put("random", MD5Util.md5_(seqNO));
            String randomKey = MD5Util.md5_(UUID.randomUUID().toString());
            reqMsg.put("sm2EncryptData", SM2Util.encryptByPublicKey(randomKey, tailongBankConfig.getTlPublicKey()));
            reqMsg.put("sm2Sign", SM2Util.signByPrivateKey(randomKey, tailongBankConfig.getSm2PrivateKey(), tailongBankConfig.getMechAppID()));
            reqMsg.put("sign", SM3Util.sign(reqMsg.getString("random") + reqMsg.getString("seqNO") + tailongBankConfig.getAppSecretKey() + randomKey));
            log.info("泰隆银行调用服务：approveDev,TL请求报文：" + reqMsg.toJSONString());
            String rspMsg = doPost(reqMsg.toJSONString(), tailongBankConfig.getTlHttpUrl() + "approveDev");
            log.info("泰隆银行响应报文：" + rspMsg);
            JSONObject rspJsonObj = JSON.parseObject(rspMsg);
            String token = "";
            if (!"000000".equals(rspJsonObj.getString("errorCode"))) {
                log.info("泰隆银行交易异常");
                return null;
            } else {
                token = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), token)) {
                    log.info("泰隆银行身份认证-SM2验签失败");
                    return null;
                } else if (!SM3Util.verify(rspJsonObj.getString("random") + rspJsonObj.getString("seqNO") + token + tailongBankConfig.getAppSecretKey(), rspJsonObj.getString("sign"))) {
                    log.info("泰隆银行验签失败，报文一致性校验失败");
                    return null;
                } else {
                    log.info("泰隆银行获得Token为：" + token);
                    redisTemplate.opsForValue().set(tailongBankConfig.getAccessTokenRedisKey(), token, tailongBankConfig.getINTERVALTIME(), TimeUnit.SECONDS);
                    return token;
                }
            }
        } catch (Exception var6) {
            var6.printStackTrace();
            log.error("泰隆银行调用获取token接口异常");
            return null;
        }
    }


    private  String doPost(String msg, String url) throws IOException {
        HttpClient httpClient = HttpClientBuilder.create().build();
        HttpPost httpPost = new HttpPost(url);
        ByteArrayEntity bae = new ByteArrayEntity(msg.getBytes());
        httpPost.setEntity(bae);
        httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        HttpResponse response = httpClient.execute(httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            byte[] bytes = EntityUtils.toByteArray(entity);
            return new String(bytes, "UTF-8");
        } else {
            return null;
        }

    }


    public String getResponseNotify(String body) {
        JSONObject rspJsonObj = JSON.parseObject(body);
        try {
            if (rspJsonObj.containsKey("rspData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(rspJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                rspJsonObj.put("sm2EncryptData", sm2Key);
                if (!SM2Util.verifyByPublicKey(rspJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), sm2Key)) {
                    log.info("身份认证-SM2验签失败");
                    return null;
                } else {
                    String rspData = SM4Util.decrypt(rspJsonObj.getString("rspData"), rspJsonObj.getString("seqNO") + this.getTLToken() + tailongBankConfig.getAppSecretKey() + sm2Key);
                    log.info("泰隆银行解密后报文：" + rspData);
                    return rspData;
                }
            }
        } catch (Exception e) {
            log.warn("泰隆银行  getResponseNotify  body = {}", body, e);
        }
        return null;
    }


    public JSONObject decrypt(JSONObject reqJsonObj) {
        try {
            log.info("待解密报文：" + reqJsonObj);
            if (!reqJsonObj.getString("appID").equals(tailongBankConfig.getMechAppID())) {
                log.error("报文有误，appID参数不一致");
                return null;
            } else if (reqJsonObj.containsKey("reqData")) {
                String sm2Key = SM2Util.decryptByPrivateKey(reqJsonObj.getString("sm2EncryptData"), tailongBankConfig.getSm2PrivateKey());
                reqJsonObj.put("sm2EncryptData", sm2Key);
                if (!SM2Util.verifyByPublicKey(reqJsonObj.getString("sm2Sign"), tailongBankConfig.getTlPublicKey(), tailongBankConfig.getMechAppID(), sm2Key)) {
                    log.info("身份认证-SM2验签失败");
                    return reqJsonObj;
                } else {
                    String reqData = SM4Util.decrypt(reqJsonObj.getString("reqData"), reqJsonObj.getString("seqNO") + reqJsonObj.getString("appAccessToken") + tailongBankConfig.getAppSecretKey() + sm2Key);//appSecretKey
                    if (SM3Util.verify(reqData + reqJsonObj.getString("seqNO") + tailongBankConfig.getAppSecretKey() + sm2Key, reqJsonObj.getString("sign"))) {
                        reqJsonObj.put("reqData", JSONObject.parse(reqData));
                        log.info("解密后报文：" + reqJsonObj.toJSONString());
                        return reqJsonObj;
                    } else {
                        log.info("报文一致性校验失败");
                        return reqJsonObj;
                    }
                }
            } else {
                log.info("报文缺少reqData,交易异常");
                return reqJsonObj;
            }
        } catch (Exception var3) {
            var3.printStackTrace();
            log.error("调用解密方法异常");
            return null;
        }
    }



}
