package cn.com.duiba.service.impl;

import cn.com.duiba.api.bo.addcredits.AddCreditsMsgDto;
import cn.com.duiba.api.bo.subcredits.SubCreditsMsgDto;
import cn.com.duiba.api.bo.subcredits.SubCreditsResultMsgDto;
import cn.com.duiba.api.bo.virtual.VirtualMsgDto;
import cn.com.duiba.api.enums.HttpRequestResultType;
import cn.com.duiba.api.enums.subcredits.SubCreditsType;
import cn.com.duiba.biz.credits.AbchinaApi;
import cn.com.duiba.biz.credits.AddCreditsToDeveloper;
import cn.com.duiba.biz.credits.JJYApi;
import cn.com.duiba.biz.credits.JiuYangApi;
import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.biz.virtual.supplier.VirtualSupplier;
import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.config.RuXinConfig;
import cn.com.duiba.constant.DelayNotifyConfig;
import cn.com.duiba.constant.ErweihuoConfig;
import cn.com.duiba.constant.NotRequestConfig;
import cn.com.duiba.constant.SkipNotifyConfig;
import cn.com.duiba.constant.WandaConfig;
import cn.com.duiba.constant.yumin.YmBankConfig;
import cn.com.duiba.domain.HttpMessageDO;
import cn.com.duiba.domain.SubCreditsMsgWrapper;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.mq.RocketMQTopicConstant;
import cn.com.duiba.notifycenter.dao.NotifyQueueDAO;
import cn.com.duiba.notifycenter.domain.NotifyQueueDO;
import cn.com.duiba.notifycenter.service.NotifyService;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CreditsService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.dto.HttpRequestMessageDto;
import cn.com.duiba.thirdparty.enums.CallbackChannelTypeEnum;
import cn.com.duiba.thirdparty.enums.DelayMsgConfigNameEnum;
import cn.com.duiba.thirdparty.enums.NotifyTypeEnum;
import cn.com.duiba.thirdparty.mq.msg.NotifyDeveloperMsg;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.CatLogTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.tool.ruxin.RuxinHttpApiClientpublicActivityGroup;
import cn.com.duiba.wolf.utils.BeanUtils;
import com.alibaba.cloudapi.sdk.model.ApiCallback;
import com.alibaba.cloudapi.sdk.model.ApiRequest;
import com.alibaba.cloudapi.sdk.model.ApiResponse;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;

@Service
public class CreditsServiceImpl implements CreditsService {

    private static final Logger LOG = LoggerFactory.getLogger(CreditsServiceImpl.class);

    @Autowired
    private ConsumerCreditsLogService consumerCreditsLogService;

    @Autowired
    private HttpAsyncClientPool httpAsyncClientPool;

    @Autowired
    private CustomService customService;

    @Autowired
    private RocketMQMsgProducer rocketMQMsgProducer;

    @Autowired
    private NotifyQueueDAO notifyQueueDAO;

    @Autowired
    private NotifyService notifyService;

    @Autowired
    private JJYApi jjyApi;

    @Autowired
    private ErweihuoConfig erweihuoConfig;

    @Autowired
    private AbchinaApi abchinaApi;

    @Resource(name = "httpCallbackExecutorService")
    private ExecutorService httpCallbackExecutorService;

	@Autowired
	private AddCreditsToDeveloper addCreditsToDeveloper;
	@Autowired
	private VirtualSupplier virtualSupplier;

    @Autowired
    private JiuYangApi jiuYangApi;

	@Autowired
    private ReconciliationBizService reconciliationBizService;

    @Autowired
    private SkipNotifyConfig skipNotifyConfig;

    @Autowired
    private DelayNotifyConfig delayNotifyConfig;

    @Autowired
    private RocketMQTopicConstant rocketMQTopicConstant;
    @Autowired
    private NotRequestConfig notRequestConfig;

    @Override
    public void subCredits(SubCreditsMsgDto subCreditsMsg) {
        CatLogTool.printCat(CatLogTool.SUB_CREDITS_COUNT);
        if (subCreditsMsg == null) {
            return;
        }
        SubCreditsMsgWrapper subCreditsMsgWrapper = new SubCreditsMsgWrapper(subCreditsMsg);
        final SubCreditsMsgWrapper request;
        try {
            request = customService.getRequestCredits(subCreditsMsgWrapper);
            reconciliationBizService.saveMqSubCreditsMsg(request);
        } catch (BizException e) {
            // 当扣积分流程由于某些原因不需要执行下去的时候 抛出此异常
            // 此处只做中断流程用  抛出异常的地方 务必保留好现场做好日志记录
            LOG.info("扣积分流程中断 aid={}, cid={}, rid={}, rType={}", subCreditsMsg.getAppId(), subCreditsMsg.getConsumerId(), subCreditsMsg.getRelationId(), subCreditsMsg.getRelationType());
            return;
        }
        HttpRequestBase http = customService.getMqSubCreditsHttpRequest(request);

        if (http == null) {
            // 智己app，请求之前异常，不发起请求
            Long appId = request.getSubCreditsMsg().getAppId();
            if (notRequestConfig.verifyAppId(appId)) {
                LOG.warn("扣积分请求发起前异常，appId:{},params:{}",appId,JSON.toJSONString(subCreditsMsg));
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                resp.setResultType(HttpRequestResultType.FAILED);
                JSONObject result = new JSONObject();
                result.put("status", "fail");
                result.put("errorMessage", notRequestConfig.getErrorMessage());
                resp.setErrorMessage(notRequestConfig.getErrorMessage());
                resp.setResponse(JSON.toJSONString(result));
                finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(JSON.toJSONString(resp)));
                return;
            } else {
                if (SubCreditsMsgDto.HTTP_POST == request.getSubCreditsMsg().getHttpType()) {
                    Map<String, String> authParams = request.getSubCreditsMsg().getAuthParams();
                    if (MapUtils.isNotEmpty(authParams)) {
                        // 移除appSecret
                        authParams.remove("appSecret");
                    }
                    http = AssembleTool.assembleRequest(request.getHttpUrl(), request.getSubCreditsMsg().getAuthParams());
                    HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [post url " + request.getHttpUrl() + "][authParams " + request.getSubCreditsMsg().getAuthParams() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
                } else {
                    http = new HttpGet(request.getHttpUrl());
                    HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [get url " + request.getHttpUrl() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
                }
            }
        } else {
            HttpRequestLog.logUrl("[action subCredits request][bizId " + request.getSubCreditsMsg().getRelationId() + "] [type " + request.getSubCreditsMsg().getRelationType() + "] [url " + request.getHttpUrl() + "][authParams " + request.getSubCreditsMsg().getAuthParams() + "][consumerId " + request.getSubCreditsMsg().getConsumerId() + "]");
        }

        setHttpHeader(request.getSubCreditsMsg(), http, request);
        httpAsyncClient(request,http);
    }

	@Override
	public void addCredits(AddCreditsMsgDto addCreditsMsgDto) {
		if(addCreditsMsgDto == null ) {
			return;
		}
		Map<String, String> paramsMap = addCreditsMsgDto.getAuthParams();
		//设置参数 走rocketmq 不设置则走 ons
		addCreditsMsgDto.getParams().put(
		        CreditsMessageDto.MESSAGE_CHANNEL_TYPE_KEY, CallbackChannelTypeEnum.ROCKETMQ.getType());
		CreditsMessageDto dto = new CreditsMessageDto();
		dto.setAppId(String.valueOf(addCreditsMsgDto.getAppId()));
		dto.setRelationId(addCreditsMsgDto.getRelationId());
		dto.setTimestamp(System.currentTimeMillis());
		dto.setConsumerId(String.valueOf(addCreditsMsgDto.getConsumerId()));
		dto.setRelationType(addCreditsMsgDto.getRelationType());
		dto.setParams(addCreditsMsgDto.getParams());
		dto.setHttpUrl(AssembleTool.assembleUrl(addCreditsMsgDto.getHttpUrl(), paramsMap));
		dto.setHttpType(CreditsMessage.HTTP_GET);
		dto.setAuthParams(paramsMap);
		dto.setCallbackTopic(addCreditsMsgDto.getCallbackTopic());
		dto.setCallbackTag(addCreditsMsgDto.getCallbackTag());
		dto.setCallbackKey(addCreditsMsgDto.getCallbackKey());
		dto.setBizId(addCreditsMsgDto.getRelationId());
        dto.setAddCreditsParams(addCreditsMsgDto.getAddCreditsParams());
		HttpMessageDO message = new HttpMessageDO();
		message.setAppId(addCreditsMsgDto.getAppId());
		message.setBizType(HttpRequestMessageDto.RETRY_ADD_CREDITS);
		message.setBizParams(JsonTool.objectToJson(dto));
        message.setNumber(0);
		addCreditsToDeveloper.submit(message);
	}

	@Override
	public void virtualExchange(VirtualMsgDto decode) {
		if(decode == null ) {
			return;
		}
		Map<String, String> paramsMap = decode.getVirtualParams().toRequestMap(decode.getAppSecret());
		SupplierRequest request = new SupplierRequest();
		request.setAppId(String.valueOf(decode.getAppId()));
		request.setAuthParams(paramsMap);
		request.setConsumerId(String.valueOf(decode.getConsumerId()));
		request.setParams(decode.getParams());
		request.setOrderId(decode.getOrderId());
		request.setSupplierOrderId(decode.getOrderId());
		request.setHttpUrl(AssembleTool.assembleUrl(decode.getHttpUrl(), paramsMap));
		request.setSupplierName(decode.getSupplierName());
		virtualSupplier.asyncSubmit(request, decode.getCallbackTopic(), decode.getCallbackTag(), decode.getCallbackKey());
	}

    private void httpAsyncClient(final SubCreditsMsgWrapper request,HttpRequestBase http){
        httpAsyncClientPool.submit(String.valueOf(request.getSubCreditsMsg().getAppId()), http, new FutureCallback<HttpResponse>() {
            String body = "";

            @Override
            public void completed(HttpResponse response) {
                CatLogTool.printCat(CatLogTool.SUB_CREDITS_SUCCESS_COUNT);
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.COMPLETED);
                    Header header = response.getEntity().getContentEncoding();
                    String result;
                    if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
                        result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
                    } else {
                        result = EntityUtils.toString(response.getEntity());
                    }

                    String relationType = null;
                    SubCreditsType subCreditsType = request.getSubCreditsMsg().getRelationType();
                    if(subCreditsType != null){
                        relationType = subCreditsType.getMsg();
                    }

                    body = customService.getResponseCredits(request.getSubCreditsMsg().getAppId(), result, Boolean.FALSE,request.getSubCreditsMsg().getAuthParams());
                    reconciliationBizService.updateCreditsRsp(request, body, Boolean.FALSE);
                    parseResponseBody(resp, HttpRequestLog.subBody(body), request.getSubCreditsMsg().getAppId(), request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType());

                } catch (Exception e) {
                    LOG.error("toDeveloper completed", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), Integer.toString(response.getStatusLine().getStatusCode()), HttpRequestLog.subBody(body));
                }
            }

            @Override
            public void failed(Exception ex) {
                CatLogTool.printCat(CatLogTool.SUB_CREDITS_FAIL_COUNT);
                LOG.error("subCreditsToDeveloper failed bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType(), ex);
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.FAILED);
                    resp.setResponse(ex.getMessage());
                } catch (Exception e) {
                    LOG.error("toDeveloper failed", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(body));
                }
            }

            @Override
            public void cancelled() {
                LOG.error("subCreditsToDeveloper cancelled bizId:" + request.getSubCreditsMsg().getRelationId() + " bizType:" + request.getSubCreditsMsg().getRelationType());
                SubCreditsResultMsgDto resp = new SubCreditsResultMsgDto();
                try {
                    resp.setResultType(HttpRequestResultType.CANCELLED);
                    resp.setResponse("http cancelled");
                } catch (Exception e) {
                    LOG.error("toDeveloper cancelled", e);
                } finally {
                    finallyBlock(request, resp, request.getSubCreditsMsg().getCallbackTopic(), request.getSubCreditsMsg().getCallbackTag(), request.getSubCreditsMsg().getCallbackTag(), "", HttpRequestLog.subBody(body));
                }
            }

        });
    }

    @Override
    public void notifyDeveloper(NotifyDeveloperMsg notifyDeveloperMsg) {
        try {
            if (skipNotifyConfig.hasNotNotify(notifyDeveloperMsg.getAppId(), notifyDeveloperMsg.getResult())) {
                LOG.info("the app skip notify, appId={}", notifyDeveloperMsg.getAppId());
                return;
            }
            //如果是二维火app，则不进行
            if(erweihuoConfig.getAppIds().contains(notifyDeveloperMsg.getAppId())){
                return;
            }
            NotifyQueueDO queue = BeanUtils.copy(notifyDeveloperMsg, NotifyQueueDO.class);
            if (queue.getTimes() == null) {
                queue.setTimes(0);
            }
            if (queue.getNotifyType() == null) {//默认结果通知，向上兼容
                queue.setNotifyType(NotifyTypeEnum.NOTIFY_RESULT.getCode());
            }
            if (NotifyTypeEnum.getByCode(queue.getNotifyType()) == null) {
                LOG.warn("通知类型不存在;queue:" + JSON.toJSONString(queue));
                return;
            }

            String errorMsg = queue.getError4developer();
            if (StringUtils.isNotBlank(errorMsg) && errorMsg.length() > 600) {
                queue.setError4developer(errorMsg.substring(0, 600));
            }
            //判断消息是否需要进行延时
            if (delayNotifyConfig.ifNeedDelay(queue.getAppId())) {
                LOG.info("[万达酒店] creditsService mq延时发送");
                JSONObject json = (JSONObject) JSONObject.toJSON(queue);
                Integer delayLevel = Optional.ofNullable(DelayNotifyConfig.getDelayLevels(queue.getAppId())).orElse(0);
                json.put(DelayMsgConfigNameEnum.DELAY_LEVEL.getName(), delayLevel);
                rocketMQMsgProducer.sendMsg(rocketMQTopicConstant.getDelayMsg(), "mq", "", json.toJSONString(), false, null);
                return;
            }

            notifyQueueDAO.insert(queue);
            notifyService.notify(queue, "remote call");
        } catch (Exception e) {
            LOG.error("notify error NotifyDeveloperMsg = "+JSON.toJSONString(notifyDeveloperMsg),e);
        }
    }

    @Override
    public void delayMsgNotify(NotifyQueueDO queue) {
        try{
            notifyQueueDAO.insert(queue);
            notifyService.notify(queue, "delay msg");
        }catch (Exception e) {
            LOG.warn("delay msg error NotifyDeveloperMsg = "+JSON.toJSONString(queue),e);
        }
    }


    /**
     * set http header
     *
     * @param request
     * @param http
     */
    private void setHttpHeader(SubCreditsMsgDto request, HttpRequestBase http,SubCreditsMsgWrapper subMsg ) {
        Long appId = request.getAppId();
        if (customService.isMobike(appId)) {
            String time = request.getParams().get("time");
            if (StringUtils.isNotEmpty(time)) {//摩拜需要在header中传递参数
                http.setHeader(new BasicHeader("time", time));
                http.setHeader(new BasicHeader("accesstoken", request.getParams().get("accesstoken")));
            }
        }
        else if (customService.isCainiao(appId)) {
            http.setHeader("Accept", "text/xml,text/javascript");
            http.setHeader("User-Agent", "top-sdk-java");
            http.setHeader("Content-Type", "application/x-www-form-urlencoded;charset=" + CaiNiaoTool.CHARSET_UTF8);
            http.setHeader("Accept-Encoding", CaiNiaoTool.CONTENT_ENCODING_GZIP);
        }
        else if(customService.isHaiDiLao(appId)){
            //海底捞定制header处理
            CreditsMessage cmg = new CreditsMessage();
            cmg.setHttpType(http.getMethod());
            cmg.setHttpUrl(subMsg.getHttpUrl());
            cmg.setAuthParams(subMsg.getSubCreditsMsg().getAuthParams());
            customService.setHaidilaoSubAndAddHttpHeader(cmg,http);
        }
        else if(customService.isRenrenTv(appId)) {
            customService.setRenrenTvSubOrAddHttpHeader(request.getAuthParams(), http);
        }
        else if (jjyApi.isJJY(appId)) {
            jjyApi.setJJYHttpHead(request.getAuthParams(), http);
        }
        else if (jiuYangApi.isJiuYangAppid(appId)) {
            jiuYangApi.setJiuYangHttpHead(http,String.valueOf(appId));
        }
    }

    /**
     * 返回响应结果到业务放
     *
     * @param req
     * @param resp
     * @param msgTopic
     * @param msgTag
     * @param msgKey
     */
    private void finallyBlock(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp, String msgTopic, String msgTag, String msgKey, String code, String callbackBody) {
        String body = null;
        try {
            resp.setRelationId(req.getSubCreditsMsg().getRelationId());
            resp.setRelationType(req.getSubCreditsMsg().getRelationType());
            resp.setParams(req.getSubCreditsMsg().getParams());
            resp.setAppId(req.getSubCreditsMsg().getAppId());
            resp.setConsumerId(req.getSubCreditsMsg().getConsumerId());
            resp.setHttpUrl(req.getHttpUrl());
            // 扣积分回调
            body = JsonTool.objectToJson(resp);
            rocketMQMsgProducer.sendMsg(msgTopic, msgTag, msgKey, body, false, null);

            saveCreditsLog(req, resp);

            //针对农行的定制需求
            addAbchinaCredits(req, resp);

        } catch (Exception e) {
            LOG.error("credits callback: bizId:" + req.getSubCreditsMsg().getRelationId() + " bizType:" + req.getSubCreditsMsg().getRelationType(), e);
        } finally {
            HttpRequestLog.logUrl("[action subCredits] [tag response] [code " + code + "] [bizId " + req.getSubCreditsMsg().getRelationId() + "] [type " + req.getSubCreditsMsg().getRelationType() + "] [callback " + resp.getResultType() + "] [body " + callbackBody + "]");
        }
    }

    private void addAbchinaCredits(SubCreditsMsgWrapper req, SubCreditsResultMsgDto resp) {
        try{
            abchinaApi.addCreditsNum(req,resp);
        }catch (Exception e){
            LOG.info("abchina addCreditsNum error", e);
        }
    }

    private void parseResponseBody(SubCreditsResultMsgDto subCreditsResultMsg, String body, Long appId, String relationId, SubCreditsType type) {
        JSONObject jsonObject = null;
        try {
            jsonObject = JSONObject.parseObject(body);
        } catch (Exception e) {
            if(body != null && body.length() > 100){
                body = body.substring(0, 100);
            }
            //暂时屏蔽到youku的返回结果为html格式错误，玉东已经在让对方的开发查原因，但对方还没有查明具体原因
            if("46112".equals(appId + "")){
                LOG.info("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", appId, relationId, type, body);
            }else{
                LOG.warn("parse subCredits json fail, appId={}, bizId={}, type={}, body={}", appId, relationId, type, body);
            }
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_PARSE_JSON_FAIL);
            subCreditsResultMsg.setResponse(body);
            return;
        }

        if (jsonObject == null) {
            subCreditsResultMsg.setResponse(body);
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_PARSE_JSON_FAIL);
            return;
        }
        // 额外信息
        JSONObject extraInfo = jsonObject.getJSONObject(SubCreditsResultMsgDto.EXTRA_INFO);

        jsonObject = getOneDegreeJson(jsonObject);
        if ("ok".equalsIgnoreCase(jsonObject.getString("status"))) {
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_SUCCESS);
            Long credits = jsonObject.getLong("credits");
            if (credits != null && credits >= 0) {
                subCreditsResultMsg.setCredits(credits);
            }
            String bizId = jsonObject.getString("bizId");
            subCreditsResultMsg.setBizId(bizId);


            if (extraInfo != null && !extraInfo.isEmpty()) {
                for (Map.Entry<String, Object> entry : extraInfo.entrySet()) {
                    if(entry.getValue() instanceof String){
                    subCreditsResultMsg.getExtraInfo().put(entry.getKey(), (String) entry.getValue());
                    }
                }
            }

        } else {
            // 扣积分失败
            subCreditsResultMsg.setCode(SubCreditsResultMsgDto.CODE_NORMAL_FAIL);
            subCreditsResultMsg.setErrorMessage(jsonObject.getString("errorMessage"));
            subCreditsResultMsg.setResponse(body);
        }
    }

    private JSONObject getOneDegreeJson(JSONObject o) {
        JSONObject json = new JSONObject();
        for (Map.Entry<String, Object> entry : o.entrySet()) {
            if (entry.getValue() instanceof JSONObject) {
                JSONObject json2 = (JSONObject) entry.getValue();
                for (Map.Entry<String, Object> entry2 : json2.entrySet()) {
                    json.put(entry2.getKey(), entry2.getValue());
                }
            } else {
                json.put(entry.getKey(), entry.getValue());
            }
        }
        return json;
    }

    /**
     * 保存积分记录
     * @param request
     * @param response
     */
    private void saveCreditsLog(SubCreditsMsgWrapper request, SubCreditsResultMsgDto response) {
        httpCallbackExecutorService.execute(() -> {
            try {
                if (HttpRequestResultType.COMPLETED.equals(response.getResultType())
                        && SubCreditsResultMsgDto.CODE_SUCCESS == response.getCode()) {
                    consumerCreditsLogService.save(request, response);
                }
            } catch (Exception e) {
                String errMsg = getErrMsg(e);
                LOG.info("积分记录保存失败, bizId={}, bizType={}",
                        request.getSubCreditsMsg().getRelationId(), request.getSubCreditsMsg().getRelationType(), errMsg);
            }
        });
    }

    private String getErrMsg(Exception e) {
        String causeMsg = "";
        if(StringUtils.isNotBlank(e.getMessage())){
            if(e.getMessage().length() > 200){
                causeMsg = e.getMessage().substring(0, 200);
            }else{
                causeMsg = e.getMessage();
            }
        }
        return causeMsg;
    }

}