package cn.com.duiba.service.impl;

import cn.com.duiba.service.DuibaVirtualManager;
import cn.com.duiba.service.DuibaVirtualSupplier;
import cn.com.duiba.thirdparty.dto.SupplierRequestDto;
import cn.com.duiba.thirdparty.enums.virtual.VirtualItemChannelEnum;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * @author qiurenjie
 * @date 2021-07-19 18:54
 */
@Component
public class DuibaVirtualConsumeManager {

    private static final Logger LOGGER = LoggerFactory.getLogger(DuibaVirtualConsumeManager.class);

    @Autowired
    private DuibaVirtualManager duibaVirtualManager;


    public void handleMqMessage(String body) {
        if (StringUtils.isBlank(body)) {
            LOGGER.info("DuibaVirtualConsumeManager.body is null");
            return;
        }
        SupplierRequestDto request = JSONObject.parseObject(body, SupplierRequestDto.class);
        VirtualItemChannelEnum virtualItemChannelEnum = VirtualItemChannelEnum.getByCode(request.getVirtualTypeCode());
        if (virtualItemChannelEnum == null) {
            LOGGER.info("DuibaVirtualConsumeManager.VirtualItemChannelEnum is null,body:{}", body);
            return;
        }
        DuibaVirtualSupplier duibaVirtualSupplier = duibaVirtualManager.getSupplier(virtualItemChannelEnum.getCode());
        if (duibaVirtualSupplier == null) {
            LOGGER.info("DuibaVirtualConsumeManager.duibaVirtualSupplier is null,body:{}", body);
            return;
        }

        LOGGER.info("开始处理兑吧虚拟商品请求,request:{}", JSON.toJSONString(request));
        duibaVirtualSupplier.submit(request);
    }

}
