package cn.com.duiba.service.reconciliation.impl;

import cn.com.duiba.dao.custom.ReconciliationRecordDao;
import cn.com.duiba.service.reconciliation.ReconciliationRecordService;
import cn.com.duiba.thirdparty.dto.reconciliation.ReconciliationRecordDto;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * Created by xutao on 2020/3/7.
 */
@Service
public class ReconciliationRecordServiceImpl implements ReconciliationRecordService {
    private static final Logger logger = LoggerFactory.getLogger(ReconciliationRecordServiceImpl.class);

    @Autowired
    private ReconciliationRecordDao reconciliationRecordDao;

    @Override
    public ReconciliationRecordDto saveOrUpdate(ReconciliationRecordDto dto) {
        List<ReconciliationRecordDto> dtoList = reconciliationRecordDao.findByUidOrderNum(dto.getOrderNum(), dto.getAppId(), dto.getPartnerUserId(), dto.getLogType(), dto.getOptId(), dto.getOptType());
        if(CollectionUtils.isEmpty(dtoList)){
            reconciliationRecordDao.insert(dto);
        }else{
            ReconciliationRecordDto reconciliationRecordDto = dtoList.get(0);
            dto.setId(reconciliationRecordDto.getId());
            reconciliationRecordDao.update(dto);
        }
        return dto;
    }

    @Override
    public Pair<Integer, Boolean> update(ReconciliationRecordDto dto) {
        List<ReconciliationRecordDto> dtoList = reconciliationRecordDao.findByUidOrderNum(dto.getOrderNum(), dto.getAppId(), dto.getPartnerUserId(), dto.getLogType(), dto.getOptId(), dto.getOptType());
        if(CollectionUtils.isEmpty(dtoList) || dtoList.size() > 1){
            logger.warn("query record more than one: {}, query:{}", JSONObject.toJSONString(dtoList), JSONObject.toJSONString(dto));
            return Pair.of(0, Boolean.FALSE);
        }

        ReconciliationRecordDto updateDto = new ReconciliationRecordDto();
        updateDto.setId(dtoList.get(0).getId());
        if(StringUtils.isNotBlank(dto.getResponseBody())){
            updateDto.setResponseBody(dto.getResponseBody());
        }
        updateDto.setResponseStatus(dto.getResponseStatus());
        Integer ret = reconciliationRecordDao.update(updateDto);
        return Pair.of(ret, Boolean.TRUE);
    }

    @Override
    public Integer updateMallOrderStatus(ReconciliationRecordDto dto) {
        List<ReconciliationRecordDto> dtoList = reconciliationRecordDao.findByUidOrderNum(dto.getOrderNum(), dto.getAppId(), dto.getPartnerUserId(), dto.getLogType(), null, dto.getOptType());
        if(CollectionUtils.isEmpty(dtoList) || dtoList.size() > 1){
            logger.info("query record update: {}, {}", JSONObject.toJSONString(dtoList), JSONObject.toJSONString(dto));
            return 0;
        }

        ReconciliationRecordDto updateDto = new ReconciliationRecordDto();
        updateDto.setId(dtoList.get(0).getId());
        updateDto.setOrderStatus(dto.getOrderStatus());
        return reconciliationRecordDao.update(updateDto);
    }

//    @Override
//    public List<ReconciliationRecordDto> findRecordBySendTime(ReconciliationRecordParam reconciliationRecordParam) {
//        if(reconciliationRecordParam == null){
//            return Collections.emptyList();
//        }
//        return reconciliationRecordDao.findRecordBySendTime(reconciliationRecordParam);
//    }
//
//    @Override
//    public int findRecordCountBySendTime(ReconciliationRecordParam reconciliationRecordParam) {
//        if(reconciliationRecordParam == null){
//            return 0;
//        }
//        return reconciliationRecordDao.findRecordCountBySendTime(reconciliationRecordParam);
//    }
}
