package cn.com.duiba.tool;

import com.dianping.cat.Cat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by zhangyongjie on 2022/2/9 2:37 下午
 */
public class CatLogTool {
    private static final Logger logger = LoggerFactory.getLogger(CatLogTool.class);

    /**
     * 加积分次数
     */
    public static final String ADD_CREDITS_COUNT = "add-credits-submit-count";

    /**
     * 加积分成功次数
     */
    public static final String ADD_CREDITS_SUCCESS_COUNT = "add-credits-success-count";


    /**
     * 加积分失败次数
     */
    public static final String ADD_CREDITS_FAIL_COUNT = "add-credits-fail-count";




    /**
     * 扣积分
     */
    public static final String SUB_CREDITS_COUNT = "sub-credits-submit-count-mq";

    /**
     * 扣积分成功次数
     */
    public static final String SUB_CREDITS_SUCCESS_COUNT = "sub-credits-success-count-mq";

    /**
     * 扣积分失败次数
     */
    public static final String SUB_CREDITS_FAIL_COUNT = "sub-credits-fail-count-mq";


    /**
     * 扣积分（remote接口）
     */
    public static final String SUB_CREDITS_COUNT_REMOTE = "sub-credits-submit-count-remote";

    /**
     * 扣积分成功次数（remote接口）
     */
    public static final String SUB_CREDITS_SUCCESS_COUNT_REMOTE = "sub-credits-success-count-remote";

    /**
     * 扣积分失败次数（remote接口）
     */
    public static final String SUB_CREDITS_FAIL_COUNT_REMOTE = "sub-credits-fail-count-remote";




    public static void printCat(String message){
        try {
            Cat.logMetricForCount(message);
        }catch (Exception e){
            logger.error("cat log print error",e);
        }
    }
}