package cn.com.duiba.tool;

/**
 * 内部异常 <功能详细描述>.
 */
public class CodeException extends RuntimeException {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 4488920747852502701L;

	/** The result code. */
	private String resultCode;

	/** The result message. */
	private String resultMessage;

	private ErrorCode errorCode;

	/**
	 * The Constructor.
	 */
	public CodeException() {
		super();
	}

	/**
	 * The Constructor.
	 * 
	 * @param code
	 *            the code
	 */
	public CodeException(ErrorCode code) {
		super(code.getDesc());
		this.errorCode = code;
		this.resultCode = code.getErrorCode();
		this.resultMessage = code.getDesc();
	}

	/**
	 * Creates a new instance of GoodsException.
	 *
	 * @param resultCode
	 * @param resultMessage
	 */

	public CodeException(String resultCode, String resultMessage) {
		super(resultMessage);
		this.resultCode = resultCode;
		this.resultMessage = resultMessage;
	}

	/**
	 * The Constructor.
	 * 
	 * @param code
	 *            the code
	 * @param cause
	 *            the cause
	 */
	public CodeException(ErrorCode code, Throwable cause) {
		super(cause);
		this.errorCode = code;
		this.resultCode = code.getErrorCode();
		this.resultMessage = code.getDesc();
	}

	/**
	 * Gets the result code.
	 * 
	 * @return the resultCode
	 */
	public String getResultCode() {
		return resultCode;
	}

	/**
	 * Sets the result code.
	 * 
	 * @param resultCode
	 *            the resultCode to set
	 */
	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	/**
	 * Gets the result message.
	 * 
	 * @return the resultMessage
	 */
	public String getResultMessage() {
		return resultMessage;
	}

	/**
	 * Sets the result message.
	 * 
	 * @param resultMessage
	 *            the resultMessage to set
	 */
	public void setResultMessage(String resultMessage) {
		this.resultMessage = resultMessage;
	}

	/**
	 * 自定义toString
	 * 
	 * @return the string
	 */
	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("GoodsException [resultCode=");
		builder.append(resultCode);
		builder.append(", resultMessage=");
		builder.append(resultMessage);
		builder.append("]");
		return builder.toString();
	}

	/**
	 * getErrorCode
	 * @return
	 */
	public ErrorCode getErrorCode() {
		return errorCode;
	}

}
