package cn.com.duiba.tool;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.*;

public class IcbcSignTool {
    private static final String MD5 = "MD5";
    private static final String ZERO = "0";

    /**
     * 构建签名
     *
     * @param paramsMap
     *            参数
     * @param secret
     *            密钥
     * @return
     * @throws IOException
     */
    public static String createSign(Map<String, ?> paramsMap, String secret) {
        Set<String> keySet = paramsMap.keySet();
        List<String> paramNames = new ArrayList<String>(keySet);

        Collections.sort(paramNames);

        StringBuilder paramNameValue = new StringBuilder();

        for (String paramName : paramNames) {
            paramNameValue.append(paramName).append(paramsMap.get(paramName));
        }

        String source = secret + paramNameValue.toString() + secret;

        return encryptUpper(source);
    }

    /**
     * 生成md5,全部大写
     *
     * @param input
     * @return
     */
    private static String encryptUpper(String input) {
        return encrypt(input).toUpperCase();
    }

    /**
     * 生成md5,全部小写
     *
     * @param input
     * @return
     */
    private static String encrypt(String input) {
        if(input == null || "".equals(input)) {
            throw new IllegalArgumentException("The argument input can not be empty.");
        }
        return encrypt(input.getBytes());
    }

    /**
     * 生成md5,全部小写
     *
     * @param input
     * @return
     */
    private static String encrypt(byte[] input) {
        if(input == null || input.length == 0) {
            throw new IllegalArgumentException("The argument input can not be empty.");
        }
        try {
            // 创建一个提供信息摘要算法的对象，初始化为md5算法对象
            MessageDigest md = MessageDigest.getInstance(MD5);
            // 计算后获得字节数组,这就是那128位了
            byte[] buff = md.digest(input);

            // 把数组每一字节（一个字节占八位）换成16进制连成md5字符串
            return byte2hex(buff);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }


    /**
     * 二进制转十六进制字符串
     *
     * @param bytes
     * @return
     */
    private static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; i++) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append(ZERO);
            }
            sign.append(hex);
        }
        return sign.toString();
    }

}
