package cn.com.duiba.tool;

/**
 * Created by fangdong on 2018/11/01
 */

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * Created by xuezhaoming on 16/6/8.
 */
public final class TableHelper {

    private static final int TABLES = 1024;

    private TableHelper(){
        //构造器
    }

    /**
     *
     * @param consumerId
     * @return
     */
    public static Map<String, Object> getTbSuffixParamsMap(Long consumerId) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("tb_suffix", getTableSuffix(consumerId));
        return params;
    }

    /**
     *
     * @param consumerId
     * @return
     */
    public static String getTableSuffix(Long consumerId) {
        Long tbInt = consumerId.longValue() % TABLES;
        String tb = tbInt + "";
        if (tbInt < 10) {
            tb = "000" + tbInt;
        } else if (tbInt < 100) {
            tb = "00" + tbInt;
        } else if (tbInt < 1000) {
            tb = "0" + tbInt;
        }

        return tb;
    }
}

