package cn.com.duiba.tool;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TreeMap;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

/**
 * @program: thirdparty-all
 * @description: 浙江联合银行
 * @author: fenghuohuo
 * @create: 2021-05-28 16:07
 **/
public class ZjUnionBankUtil {

    private static final String SHA_256_WITH_RSA = "SHA256withRSA";
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String RSA = "RSA";

    /**
     * 签名
     *
     * @param reqMsg
     * @param privateKey
     * @return
     * @throws Exception
     */
    public static String sign(JSONObject reqMsg, String privateKey) throws Exception {
        return sign(reqMsg, getPrivateKey(privateKey));
    }

    /**
     * 签名
     *
     * @param reqMsg
     * @param privateKey
     * @return
     * @throws Exception
     */
    public static String sign(JSONObject reqMsg, PrivateKey privateKey) throws Exception {
        String sb = getStrByParam(reqMsg);
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(privateKey);
        signature.update(sha256(sb.getBytes("UTF-8")).toLowerCase()
            .getBytes());
        // signature.update(data.getBytes("UTF-8"));
        return Base64.encodeBase64String(signature.sign());
    }

    public static final String bytesToHexString(byte[] bArray) {
        StringBuffer sb = new StringBuffer(bArray.length);
        String sTemp;
        for (int i = 0; i < bArray.length; i++) {
            sTemp = Integer.toHexString(0xFF & bArray[i]);
            if (sTemp.length() < 2) {
                sb.append(0);
            }
            sb.append(sTemp.toUpperCase());
        }
        return sb.toString();
    }

    public static String sha256(byte[] data) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        return bytesToHexString(messageDigest.digest(data));
    }

    /**
     * SHA256WithRSA/PSS 验签
     *
     * @param reqMsg       明文
     * @param signText     签名
     * @param publicKeyStr 公钥base64编码字符串
     * @return
     * @throws Exception
     */
    public static boolean verifySign(JSONObject reqMsg, String signText, String publicKeyStr)
        throws Exception {
        if (reqMsg == null || signText == null || publicKeyStr == null) {
            return false;
        }
        String sb = getStrByParam(reqMsg);
        return verifySign(sb, signText, getPublicKey(publicKeyStr));
    }

    private static String getStrByParam(JSONObject reqMsg) {
        TreeMap<String, String> sortParams = new TreeMap<String, String>(
            JSONObject.toJavaObject(reqMsg, Map.class));
        TreeMap<String, String> tree = new TreeMap<String, String>();
        Iterator<Entry<String, String>> it = sortParams.entrySet().iterator();

        Set<String> keySets = sortParams.keySet();
        List<String> keyList = new ArrayList<String>();
        for (String key : keySets) {
            keyList.add(key);
        }
        Collections.sort(keyList);

        while (it.hasNext()) {
            Entry<String, String> en = it.next();
            tree.put(en.getKey(), en.getValue());
        }
        it = tree.entrySet().iterator();
        StringBuffer sf = new StringBuffer();
        for (int i = 0; i < keyList.size(); i++) {
            String key = keyList.get(i);
            String value = tree.get(key);
            if (!"signature".equals(key) && !"sign".equals(key)) {
                sf.append(key + "=" + value + "&");
            }
        }

        return sf.substring(0, sf.length() - 1);
    }

    /**
     * SHA256WithRSA/PSS 验签
     *
     * @param plainText 明文
     * @param signText  签名
     * @param publicKey 公钥
     */
    public static boolean verifySign(String plainText, String signText, PublicKey publicKey)
        throws Exception {
        Signature verifySign = Signature.getInstance(SHA_256_WITH_RSA);
        verifySign.initVerify(publicKey);
        verifySign.update(sha256(plainText.getBytes()).toLowerCase().getBytes(StandardCharsets.UTF_8));
        return verifySign.verify(Base64.decodeBase64(signText));
    }

    /**
     * String转公钥PublicKey
     *
     * @param publicKeyStr
     * @return
     * @throws Exception
     */
    public static PublicKey getPublicKey(String publicKeyStr) throws Exception {
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64.decodeBase64(publicKeyStr));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePublic(keySpec);
    }

    /**
     * String转私钥PrivateKey
     *
     * @param key
     * @return
     * @throws Exception
     */
    public static PrivateKey getPrivateKey(String key) throws Exception {
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(key));
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    public static String encerypt(String data, String publicKeyStr) throws Exception {
        Cipher cipher;
        cipher = Cipher.getInstance(RSA);
        byte[] cipherText;
        cipher.init(Cipher.ENCRYPT_MODE, getPublicKey(publicKeyStr));
        cipherText = cipher.doFinal(data.getBytes());
        // 加密后的东西
        return Base64.encodeBase64String(cipherText);
    }
}
