package cn.com.duiba.tool.kunshanRCB;

import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;

import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;


public class EncryptAPI {
    private static SM2 sm2 = new SM2();
    private static SM4 sm4 = new SM4();
    private static Util util = new Util();
    private static DecimalFormat df = new DecimalFormat("0000");


    /*
     * 功能：公钥加密(C1C2C3模式)
     * 入参：String publicKey, String data
     * 返回: String encData
     */
    public static String encryptByPK1(String publicKey, String data) throws IOException {
        if (publicKey == null || publicKey.length() == 0) {
            return null;
        }

        if (data == null || data.length() == 0) {
            return null;
        }
        publicKey = "04" + publicKey;
        byte[] publicKeyBytes = ByteUtils.fromHexString(publicKey);
        byte[] plainTextBytes = ByteUtils.fromHexString(data);
        byte[] source = new byte[plainTextBytes.length];
        System.arraycopy(plainTextBytes, 0, source, 0, plainTextBytes.length);


        Cipher cipher = new Cipher();
        ECPoint userKey = sm2.ECC_CURVE.decodePoint(publicKeyBytes);

        ECPoint c1 = cipher.initEnc(sm2, userKey);
        cipher.Encrypt(source);
        byte[] c3 = new byte[32];
        cipher.Dofinal(c3);
        String C1 = Util.byteToHex(c1.getEncoded());
        String C2 = Util.byteToHex(source);
        String C3 = Util.byteToHex(c3);
        String encData = C1 + C2 + C3;
        //C1 C2 C3拼装成加密字串
        return encData.substring(2, encData.length());
    }


    /*
     * 功能：私钥解密 C1C2C3
     * 入参：String privateKey , String encryptedData
     * 返回：String plainData
     */
    public static String decryptByVK1(String privateKey, String encryptedData) throws IOException {
        if (privateKey == null || privateKey.length() == 0) {
            return null;
        }

        if (encryptedData == null || encryptedData.length() == 0) {
            return null;
        }
        //加密字节数组转换为十六进制的字符串 长度变为encryptedData.length * 2

        String data = "04" + encryptedData;
        /***分解加密字串
         * （C1 = C1标志位2位 + C1实体部分128位 = 130）
         * （C3 = C3实体部分64位  = 64）
         * （C2 = encryptedData.length * 2 - C1长度  - C2长度）
         */
        byte[] c1Bytes = Util.hexToByte(data.substring(0, 130));
        int c2Len = Util.hexToByte(data).length - 97;
        byte[] c2 = Util.hexToByte(data.substring(130, 130 + 2 * c2Len));
        byte[] c3 = Util.hexToByte(data.substring(130 + 2 * c2Len, 194 + 2 * c2Len));

        BigInteger userD = new BigInteger(1, Util.hexToByte(privateKey));

        //通过C1实体字节来生成ECPoint
        ECPoint c1 = sm2.ECC_CURVE.decodePoint(c1Bytes);
        Cipher cipher = new Cipher();
        cipher.initDec(userD, c1);
        cipher.Decrypt(c2);
        cipher.Dofinal(c3);
        String plainData = Util.byteToHex(c2);
        //返回解密结果
        return plainData;
    }

    /**
     * encryptDataEnvelop 数字信封加密
     *
     * @param pkValue 公钥值
     * @param data    待加密的数据明文
     * @return envelop     数据信封(含sm4密钥密文、数据密文)
     */
    public static String[] encryptDataEnvelop(String pkValue, String data) throws Exception {
        if (pkValue == null || pkValue.length() == 0) {
            return null;
        }
        if (data == null || data.length() == 0) {
            return null;
        }

        String[] envelop = new String[2];

        //将tmpData转为Hex
        String hexData = util.asciiToHex(data);
        String tmpData = util.asciiToHex(df.format(hexData.length() / 2)) + hexData;

        int length = tmpData.getBytes("gb18030").length;

        //数据长度+数据明文+填充0 直至总长度为32的倍数，组成tmpData。
        if (length % 32 != 0) {
            int numOfzero = 32 - length % 32;
            for (int i = 0; i < numOfzero / 2; i++) {
                tmpData = tmpData + "30";
            }
        }
        hexData = tmpData;

        //1.随机生成SM4密钥
        String sm4Key = sm4.generateKey();
        //2.公钥加密SM4密钥
        String keyByPK = encryptByPK1(pkValue, sm4Key);
        //3.SM4密钥加密数据明文
        String encData = sm4.encryptECB(sm4Key, hexData.toUpperCase());

        envelop[0] = keyByPK;
        envelop[1] = encData;

        return envelop;
    }

    /**
     * encryptDataEnvelop 数字信封解密
     *
     * @param vk      私钥值
     * @param keyByPK 公钥加密的sm4Key
     * @return envelop     数据信封(含sm4密钥明文、数据明文)
     */
    public static String[] decryptDataEnvelop(String vk, String keyByPK, String encData) throws Exception {
        String[] envelop = new String[2];
        //私钥解密SM4对称密钥
        String sm4Key = decryptByVK1(vk, keyByPK);
        //SM4算法解密数据，得到的是4字节填充+hex数据+30填充
        String plainData = sm4.decryptECB(sm4Key, encData).toUpperCase();

        //去填充，得到明文
        int lenOfdata = Integer.parseInt(util.hexToAscii(plainData.substring(0, 8)));
        String hexData = plainData.substring(8, 8 + lenOfdata * 2);
        String ascData = new String(util.hexStringToBytes(hexData), "gb18030");

        envelop[0] = sm4Key;
        envelop[1] = ascData;

        return envelop;
    }


}
