package cn.com.duiba.tool.kunshanRCB;

import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECFieldElement.Fp;
import org.bouncycastle.math.ec.ECPoint;

import java.math.BigInteger;
import java.security.SecureRandom;


public class SM2 {

    //正式参数
    public static String[] eccParam = {
            "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF",
            "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC",
            "28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93",
            "FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123",
            "32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7",
            "BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0"
    };
    public static BigInteger eccA;
    public static BigInteger eccB;
    public static BigInteger eccGx;
    public static BigInteger eccGy;
    public final BigInteger ECC_P;
    public final BigInteger ECC_N;
    public final ECCurve ECC_CURVE;
    public final ECPoint ECC_POINT_G;
    public final ECDomainParameters ECC_BC_SPEC;
    public final ECKeyPairGenerator ECC_KEY_PAIR_GENERATOR;
    public final ECFieldElement ECC_GX_FIELDELEMENT;
    public final ECFieldElement ECC_GY_FIELDELEMENT;

    public SM2() {
        this.ECC_P = new BigInteger(eccParam[0], 16);
        this.eccA = new BigInteger(eccParam[1], 16);
        this.eccB = new BigInteger(eccParam[2], 16);
        this.ECC_N = new BigInteger(eccParam[3], 16);
        this.eccGx = new BigInteger(eccParam[4], 16);
        this.eccGy = new BigInteger(eccParam[5], 16);

        this.ECC_GX_FIELDELEMENT = new Fp(this.ECC_P, this.eccGx);
        this.ECC_GY_FIELDELEMENT = new Fp(this.ECC_P, this.eccGy);

        this.ECC_CURVE = new ECCurve.Fp(this.ECC_P, this.eccA, this.eccB);
        this.ECC_POINT_G = new ECPoint.Fp(this.ECC_CURVE, this.ECC_GX_FIELDELEMENT, this.ECC_GY_FIELDELEMENT, false);

        this.ECC_BC_SPEC = new ECDomainParameters(this.ECC_CURVE, this.ECC_POINT_G, this.ECC_N);

        ECKeyGenerationParameters ecc_ecgenparam;
        ecc_ecgenparam = new ECKeyGenerationParameters(this.ECC_BC_SPEC, new SecureRandom());

        this.ECC_KEY_PAIR_GENERATOR = new ECKeyPairGenerator();
        this.ECC_KEY_PAIR_GENERATOR.init(ecc_ecgenparam);
    }


}