package cn.com.duiba.tool.kunshanRCB;


import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import org.bouncycastle.util.encoders.Hex;

import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.SecureRandom;
import java.security.Security;

public class SM4 {
    public static final String ALGORITHM_NAME = "SM4";
    private static Util util1 = new Util();

    static {
        Security.addProvider(new BouncyCastleProvider());
    }

    /**
     * 随机生成SM4密钥
     *
     * @param
     * @return String key
     * @throws Exception
     */
    public static String generateKey() throws Exception {
        KeyGenerator kg = KeyGenerator.getInstance("SM4", BouncyCastleProvider.PROVIDER_NAME);
        kg.init(128, new SecureRandom());
        String key = Hex.toHexString(kg.generateKey().getEncoded()).toUpperCase();
        return key;
    }

    /**
     * SM4 加密，ECB模式
     *
     * @param hexKey  密钥
     * @param data  待加密数据明文
     * @throws Exception
     */
    public static String encryptECB(String hexKey, String data) throws Exception {
        String encData = "";

        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] srcData = util1.hexStringToBytes(data);
        Key sm4Key = new SecretKeySpec(keyData, ALGORITHM_NAME);

        Cipher cp = Cipher.getInstance("SM4/ECB/NOPADDING", BouncyCastleProvider.PROVIDER_NAME);

        cp.init(Cipher.ENCRYPT_MODE, sm4Key);
        byte[] encDataArray = cp.doFinal(srcData);
        encData = ByteUtils.toHexString(encDataArray).toUpperCase();

        return encData;
    }

    public static String decryptECB(String hexKey, String cipherText) throws Exception {
        String plainData = "";
        byte[] keyData = ByteUtils.fromHexString(hexKey);
        byte[] cipherData = util1.hexStringToBytes(cipherText);

        Cipher cipher = Cipher.getInstance("SM4/ECB/NOPADDING", BouncyCastleProvider.PROVIDER_NAME);
        Key sm4Key = new SecretKeySpec(keyData, ALGORITHM_NAME);
        cipher.init(Cipher.DECRYPT_MODE, sm4Key);
        byte[] srcData = cipher.doFinal(cipherData);
        plainData = ByteUtils.toHexString(srcData).toUpperCase();

        return plainData;
    }

}
