package cn.com.duiba.tool.sn;

public class Hex {

    private static final char[] DIGITS_LOWERCASE = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c',
            'd', 'e', 'f' };

    private static final char[] DIGITS_UPPERCASE = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C',
            'D', 'E', 'F' };

    public static byte[] toByte(CharSequence hex) {
        int length = hex.length();
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Hex-encoded string must have an even number of characters");
        }

        byte[] result = new byte[length / 2];

        for (int i = 0; i < length; i += 2) {
            int msb = Character.digit(hex.charAt(i), 16);
            int lsb = Character.digit(hex.charAt(i + 1), 16);

            if ((msb < 0) || (lsb < 0)) {
                throw new IllegalArgumentException(
                        "Detected a Non-hex character at " + (i + 1) + " or " + (i + 2) + " position");
            }

            result[(i / 2)] = (byte) (msb << 4 | lsb);
        }
        return result;
    }

    public static String toHex(byte[] bytes) {
        return toHex(bytes, true);
    }

    public static String toHex(byte[] bytes, boolean toLowerCase) {
        return toHex(bytes, (toLowerCase) ? DIGITS_LOWERCASE : DIGITS_UPPERCASE);
    }

    private static String toHex(byte[] bytes, char[] digits) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array is null");
        }
        int length = bytes.length;
        char[] result = new char[2 * length];

        int j = 0;
        for (int i = 0; i < length; ++i) {
            result[(j++)] = digits[((0xF0 & bytes[i]) >>> 4)];

            result[(j++)] = digits[(0xF & bytes[i])];
        }
        return new String(result);
    }

}
