package cn.com.duiba.biz.credits;

import cn.com.duiba.biz.Exception.ThirdpatyException;
import cn.com.duiba.constant.SiChuanLianTongConfig;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.tool.AssembleTool;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 四川联通定制api
 *
 * @Author chenxiangge
 * @Date 2020/12/15
 */
@Service
public class SiChuanLianTongApi {
    private static final Logger LOGGER = LoggerFactory.getLogger(SiChuanLianTongApi.class);


    private static final String CHARACTER_ENCODE = "UTF-8";

    private static final String SUCCESS_CODE = "0000";

    @Autowired
    private SiChuanLianTongConfig siChuanLianTongConfig;

    public Boolean isSiChuanLianTongApp(Long appId) {
        return siChuanLianTongConfig.isSiChuanLianTongApp(appId);
    }

    /**
     * 虚拟商品请求
     *
     * @param request
     * @return
     */
    public HttpRequestBase getVirtualRequest(SupplierRequest request) {
        String url = request.getHttpUrl();
        String newUrl = url.substring(0, url.indexOf('?'));
        String queryString = url.substring(newUrl.length() + 1);
        // 1.将请求URL的参数转换为MAP
        Map<String, String> params = AssembleTool.getUrlParams(queryString);

        String cusParams = null;
        try {
            cusParams = URLDecoder.decode(params.get("params"),"utf-8");
            LOGGER.info("10010 params:{}", cusParams);
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String[] cusParamsArr = cusParams.split("\\|");
        boolean isPackage = cusParamsArr.length >= 5;

        String appId = siChuanLianTongConfig.getClientId();
        String appSecret = siChuanLianTongConfig.getClientSecret();

        Long timestamp = System.currentTimeMillis();
        String signUrl = isPackage ? siChuanLianTongConfig.getPackageSignUrl() : siChuanLianTongConfig.getSignUrl();
        String sign = DigestUtils.md5Hex("appId=" + appId + ",timestamp=" + timestamp + "," + signUrl + "," + appSecret);

        //签名并获取token
        // {appId:{appId, timestamp:{timestamp}, sign:{1步骤的签名串}}}
        JSONObject json = new JSONObject();
        json.put("appId", appId);
        json.put("timestamp", timestamp);
        json.put("sign", sign);
        String token = "";
        try {
            token = Hex.encodeHexString(JSON.toJSONString(json).getBytes(CHARACTER_ENCODE));
        } catch (Exception e) {
            LOGGER.warn("四川联通 虚拟商品定制，生成token异常", e);
        }

        //拼接请求url
        newUrl = newUrl + "?accessTokenKind=2&accessToken=" + token;

        // 新增定制逻辑 格式 abilityPathId|elementId|elementType|packageId|productId
        if(isPackage){
            // 1:替换abilityPathId oldUrl = "https://scaop.169ol.com:8302/ability/210040?accessTokenKind=2"
            String[] urlArr = newUrl.substring(0, newUrl.indexOf("?")).split("/");
            for (int i = 0; i < urlArr.length; i++) {
                if (StringUtils.equals(urlArr[i], "ability")) {
                    newUrl = StringUtils.replace(newUrl, urlArr[i + 1], cusParamsArr[0]);
                    url = StringUtils.replace(url, urlArr[i + 1], cusParamsArr[0]);
                }
            }
            LOGGER.info("10010 url:{}", newUrl);

            Map<String, Object> requestParams = new HashMap<>();

            // 2:可配置参数
            PackageElement packageElement = new PackageElement();
            packageElement.setElementId(cusParamsArr[1]);
            packageElement.setElementType(cusParamsArr[2]);
            packageElement.setPackageId(cusParamsArr[3]);

            productInfo product = new productInfo();
            product.setProductId(cusParamsArr[4]);
            product.setPackageElement(Arrays.asList(packageElement));

            msg msg = new msg();
            msg.setOrdersId(request.getOrderId());
            msg.setSerialNumber(params.get("uid"));
            msg.setProductInfo(Arrays.asList(product));

            requestParams.put("msg", msg);

            String requestJson = JSON.toJSONString(requestParams);
            HttpPost httpPost = new HttpPost(newUrl);
            httpPost.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));

            LOGGER.info("10010 body:{}", requestJson);

            request.setHttpUrl(url);

            Map<String, String> authParams = new HashMap<>();
            authParams.put("msg", JSON.toJSONString(msg));
            request.setAuthParams(authParams);

            return httpPost;
        }// 原逻辑
        else{
            LOGGER.info("10010 url:{}", newUrl);

            Map<String, String> requestParams = new HashMap<>();
            requestParams.put("acceptWay", siChuanLianTongConfig.getAcceptWay());
            requestParams.put("phoneNumber", params.get("uid"));
            requestParams.put("rightsId", params.get("params"));

            String requestJson = JSON.toJSONString(requestParams);

            HttpPost httpPost = new HttpPost(newUrl);
            httpPost.setEntity(new StringEntity(requestJson, ContentType.APPLICATION_JSON));

            LOGGER.info("10010 body:{}", requestJson);

            request.setHttpUrl(url);
            request.setAuthParams(requestParams);

            return httpPost;
        }

    }


    /**
     * 开发者虚拟商品返回解析
     *
     * @param body
     * @return
     */
    public String getVirtualResponse(String body) {
        LOGGER.info("四川联通,虚拟商品定制 返回结果:{}",body);
        Map<String, String> map = new HashMap<>();
        if (StringUtils.isBlank(body)) {
            throw new ThirdpatyException("四川联通,虚拟商品定制，返回结果为空");
        }
        try {
            SiChuanLianTongResponse data = JSON.parseObject(body, SiChuanLianTongResponse.class);
            Boolean isOk = SUCCESS_CODE.equals(data.getBusiCode()) && SUCCESS_CODE.equals(data.getCode());
            map.put("status", isOk ? "success" : "fail");
            if (!isOk) {
                LOGGER.info("四川联通,虚拟商品定制 错误返回:{}",body);
                map.put("errorMessage", data.getBusiDetail());
                map.put("code", data.getBusiCode());
            }
        } catch (Exception e) {
            LOGGER.error("四川联通,虚拟商品定制，结果解析错误:{}", body, e);
            map.put("status", "fail");
            map.put("errorMessage", "虚拟商品充值接口响应解析错误");
        }
        return JSON.toJSONString(map);
    }

    static class SiChuanLianTongResponse {
        private String code;
        private String detail;
        private String busiCode;
        private String busiDetail;

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getDetail() {
            return detail;
        }

        public void setDetail(String detail) {
            this.detail = detail;
        }

        public String getBusiCode() {
            return busiCode;
        }

        public void setBusiCode(String busiCode) {
            this.busiCode = busiCode;
        }

        public String getBusiDetail() {
            return busiDetail;
        }

        public void setBusiDetail(String busiDetail) {
            this.busiDetail = busiDetail;
        }
    }

    static class productInfo {
        private String productId;
        private String productMode = "0";
        private String optType = "00";

        private List<PackageElement> packageElement;

        public String getOptType() {
            return optType;
        }

        public void setOptType(String optType) {
            this.optType = optType;
        }

        public List<PackageElement> getPackageElement() {
            return packageElement;
        }

        public void setPackageElement(List<PackageElement> packageElement) {
            this.packageElement = packageElement;
        }

        public String getProductId() {
            return productId;
        }

        public void setProductId(String productId) {
            this.productId = productId;
        }

        public String getProductMode() {
            return productMode;
        }

        public void setProductMode(String productMode) {
            this.productMode = productMode;
        }
    }

    static class PackageElement {
        private String elementId;
        private String modType = "0";
        private String packageId;
        private String elementType;

        public String getElementId() {
            return elementId;
        }

        public void setElementId(String elementId) {
            this.elementId = elementId;
        }

        public String getModType() {
            return modType;
        }

        public void setModType(String modType) {
            this.modType = modType;
        }

        public String getPackageId() {
            return packageId;
        }

        public void setPackageId(String packageId) {
            this.packageId = packageId;
        }

        public String getElementType() {
            return elementType;
        }

        public void setElementType(String elementType) {
            this.elementType = elementType;
        }
    }

    static class msg {
        private String ordersId;
        private String serialNumber;
        private String changeType = "1";
        private String deductionTag = "1";
        private List<productInfo> productInfo;

        public String getOrdersId() {
            return ordersId;
        }

        public void setOrdersId(String ordersId) {
            this.ordersId = ordersId;
        }

        public String getSerialNumber() {
            return serialNumber;
        }

        public void setSerialNumber(String serialNumber) {
            this.serialNumber = serialNumber;
        }

        public String getChangeType() {
            return changeType;
        }

        public void setChangeType(String changeType) {
            this.changeType = changeType;
        }

        public String getDeductionTag() {
            return deductionTag;
        }

        public void setDeductionTag(String deductionTag) {
            this.deductionTag = deductionTag;
        }

        public List<productInfo> getProductInfo() {
            return productInfo;
        }

        public void setProductInfo(List<productInfo> productInfo) {
            this.productInfo = productInfo;
        }
    }

}
