package cn.com.duiba.biz.credits.unionpay;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author zhangruofan
 * @date 2019/02/15
 */
@Component
public class UnionPayManager implements InitializingBean {
    private static final Map<Long, UnionPayRequest> MAP = new HashMap<>();
    @Autowired
    private List<UnionPayRequest> unionPayRequestList;

    public UnionPayRequest getRequest(Long appId) {
        if (appId == null || appId == 0) {
            return null;
        }
        return MAP.get(appId);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        for (UnionPayRequest request : unionPayRequestList) {
            if(CollectionUtils.isEmpty(request.getAppIdSet())){
                continue;
            }
            for(Long appId : request.getAppIdSet()){
                MAP.put(appId, request);
            }
        }
    }
}
