package cn.com.duiba.biz.virtual.supplier;

import cn.com.duiba.api.bo.credits.CreditsRequest;
import cn.com.duiba.api.bo.credits.CreditsResponse;
import cn.com.duiba.biz.credits.ChangChengApi;
import cn.com.duiba.biz.credits.GangZhongLvApi;
import cn.com.duiba.biz.credits.GuMingApi;
import cn.com.duiba.biz.credits.HaoXiangNiApi;
import cn.com.duiba.biz.credits.HongQiApi;
import cn.com.duiba.biz.credits.HuaweiApi;
import cn.com.duiba.biz.credits.IcbcElifeApi;
import cn.com.duiba.biz.credits.LivatApi;
import cn.com.duiba.biz.credits.MingYuJiuDianApi;
import cn.com.duiba.biz.credits.NewInoherbApi;
import cn.com.duiba.biz.credits.QiaQiaApi;
import cn.com.duiba.biz.credits.ReconciliationBizService;
import cn.com.duiba.biz.credits.ShanXiSecuritiesApi;
import cn.com.duiba.biz.credits.SiChuanLianTongApi;
import cn.com.duiba.biz.credits.SpdBankApi;
import cn.com.duiba.biz.credits.UnionPayApi;
import cn.com.duiba.biz.credits.WatsonsApi;
import cn.com.duiba.biz.credits.WuFangZhaiApi;
import cn.com.duiba.biz.credits.nongzonghang.NongZongHangApi;
import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.config.PinganConfig;
import cn.com.duiba.domain.RequestTypeEnum;
import cn.com.duiba.domain.SupplierRequest;
import cn.com.duiba.domain.SupplierResponse;
import cn.com.duiba.mq.RocketMQMsgProducer;
import cn.com.duiba.order.center.api.dto.CreditsCallbackMessage;
import cn.com.duiba.order.center.api.dto.CreditsMessage;
import cn.com.duiba.service.ConsumerCreditsLogService;
import cn.com.duiba.service.CustomService;
import cn.com.duiba.service.HttpAsyncClientPool;
import cn.com.duiba.service.MessageService;
import cn.com.duiba.thirdparty.dto.ConsumerCreditsLogSaveDto;
import cn.com.duiba.thirdparty.dto.CreditsMessageDto;
import cn.com.duiba.thirdparty.enums.CreditsLogChangeTypeEnum;
import cn.com.duiba.thirdparty.enums.CreditsLogStatusEnum;
import cn.com.duiba.tool.AssembleTool;
import cn.com.duiba.tool.CaiNiaoTool;
import cn.com.duiba.tool.HttpRequestLog;
import cn.com.duiba.tool.JsonTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import cn.com.duiba.wolf.utils.BeanUtils;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import cn.com.duibaboot.ext.autoconfigure.httpclient.ssre.CanAccessInsideNetwork;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutorService;

/**
 * 虚拟商品接口请求
 */
@Service
public class VirtualSupplier {

	private static Logger log = LoggerFactory.getLogger(VirtualSupplier.class);

	@Autowired
	private MessageService messageService;
	@Autowired
	private RocketMQMsgProducer rocketMQMsgProducer;
	@Autowired
	private HttpAsyncClientPool httpAsyncClientPool;
	@Autowired
	private CustomService customService;
	@Autowired
	private GangZhongLvApi gangZhongLvApi;
	@Autowired
	private QiaQiaApi qiaQiaApi;
	@Autowired
	private WuFangZhaiApi wuFangZhaiApi;
	@Autowired
	private NongZongHangApi nongZongHangApi;
	@Autowired
	private LivatApi livatApi;
	@Autowired
	private GuMingApi guMingApi;
	@Autowired
	private WatsonsApi watsonsApi;
	@Autowired
	private UnionPayApi unionPayApi;
	@Autowired
	private ReconciliationBizService reconciliationBizService;
	@Autowired
	private IcbcElifeApi icbcElifeApi;
	@Autowired
	private HuaweiApi huaweiApi;

	@Autowired
	private NewInoherbApi newInoherbApi;
	@Autowired
	private MingYuJiuDianApi mingYuJiuDianApi;
	@Autowired
	private SiChuanLianTongApi siChuanLianTongApi;
	@Autowired
	private HaoXiangNiApi haoXiangNiApi;
	@Autowired
	private ChangChengApi changChengApi;
	@Autowired
	private SpdBankApi spdBankApi;
	@Autowired
	private ShanXiSecuritiesApi shanXiSecuritiesApi;
	@Autowired
	private HongQiApi hongQiApi;
	@Resource(name = "httpClient")
	@CanAccessInsideNetwork
    private CloseableHttpClient httpClient;
	@Resource(name = "executorService")
	private ExecutorService executorService;
	@Resource
	private PinganConfig pinganConfig;
	@Resource
	private ConsumerCreditsLogService consumerCreditsLogService;

	/**
	 * 提交到HTTP请求池
	 *
	 * @param mes
	 * @param callbackTopic
	 * @param msgTag
	 * @param msgKey
	 */
	public void asyncSubmit(SupplierRequest mes, final String callbackTopic, final String msgTag, final String msgKey) {
		final SupplierRequest message = customService.getVirturalRequest(mes);
		HttpRequestBase http = getRequest(message);
		//如果兑换商品是积分 这里需要记录一条加积分流水用于对账
		reconciliationBizService.saveVirtualAddCreditsMsg(message);
		String reqUrl = null == http ? "" : http.getURI().toString();
		HttpRequestLog.logUrl("[action virtual][request bizId " + message.getOrderId() + "]" +
				"[url " + reqUrl + "][authParams " + message.getAuthParams() + "]");
		httpAsyncClientPool.submit(message.getAppId(), http, new FutureCallback<HttpResponse>() {

			@Override
			public void completed(HttpResponse response) {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setSupplierName(message.getSupplierName());
					resp.setUrl(message.getHttpUrl());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_COMPLETED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());

					Header header = response.getEntity().getContentEncoding();
					String result;
					if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
						result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
					} else {
						result = EntityUtils.toString(response.getEntity());
					}
					String body = customService.getVirturalResponse(message, result,callbackTopic,msgTag,msgKey, response);
					//更新积分流水对账单 成功或者失败
					reconciliationBizService.updateVirtualAddCreditsRsp(message, body);
					resp.setBody(HttpRequestLog.subBody(body));
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, Integer.toString(response.getStatusLine().getStatusCode()));
				}
			}

			@Override
			public void failed(Exception ex) {
				log.error("VirtualSupplier failed orderId:" + message.getOrderId(), ex);
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_FAILED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
					resp.setErrorMessage(ex.getClass().getName() + ":" + ex.getMessage());
				} catch (Exception e) {
					log.error("VirtualSupplier completed", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
				}
			}

			@Override
			public void cancelled() {
				SupplierResponse resp = new SupplierResponse();
				try {
					resp.setOrderId(message.getOrderId());
					resp.setSupplierOrderId(message.getSupplierOrderId());
					resp.setCallbackType(SupplierResponse.CALLBACK_TYPE_CANCELLED);
					resp.setAppId(message.getAppId());
					resp.setConsumerId(message.getConsumerId());
				} catch (Exception e) {
					log.error("VirtualSupplier cancelled", e);
				} finally {
					finallyBlock(message, resp, callbackTopic, msgTag, msgKey, "");
				}
			}

		}, RequestTypeEnum.VIRTUAL);

	}


	/**
	 * 同步调用，不关联兑吧
	 */
	public DubboResult<String> syncSubmitWithoutDuiba(SupplierRequest supplierRequest) {
		final SupplierRequest message = customService.getVirturalRequest(supplierRequest);
		HttpRequestBase http = getRequest(message);

		log.info("http:{}", JSON.toJSONString(http));
		String reqUrl = null == http ? "" : http.getURI().toString();
		HttpRequestLog.logUrl("[action virtual][request bizId " + message.getOrderId() + "]" +
				"[messageUrl " + message.getHttpUrl() + "][url " + reqUrl + "][authParams " + message.getAuthParams() + "]");
		try (CloseableHttpResponse response = httpClient.execute(http)) {
			Header header = response.getEntity().getContentEncoding();
			String result;
			if (header != null && header.toString().contains(CaiNiaoTool.CONTENT_ENCODING_GZIP)) {
				result = EntityUtils.toString(new GzipDecompressingEntity(response.getEntity()));
			} else {
				result = EntityUtils.toString(response.getEntity());
			}
			String body = customService.getVirturalResponse(message, result, null, null, null, response);
			return DubboResult.successResult(body);
		} catch (Exception e) {
			log.warn("发送请求失败,supplierRequest={}", JSON.toJSONString(supplierRequest), e);
			return DubboResult.failResult("发送请求失败");
		}
	}

	private HttpRequestBase getRequest(SupplierRequest message){//NOSONAR
		HttpRequestBase http=null;
		Long appId = Long.valueOf(message.getAppId());
		if(customService.isMobike(appId)){
			http= AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			String time=message.getParams().get("time");
			if(StringUtils.isNotEmpty(time)){//摩拜需要在header中传递参数
				http.setHeader(new BasicHeader("time",time));
				http.setHeader(new BasicHeader("accesstoken",message.getParams().get("accesstoken")));
			}
		} else if(customService.isIqiyi(appId)
				|| customService.isWeibo(appId)
				|| customService.isPayqb(appId)
				|| customService.isSuning(appId)) {
			http= AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
		} else if(customService.isJiuYangAppid(appId)){
			String getAutuData = message.getAuthParams().get("getAuthDatas");
			if(getAutuData!=null && "ok".equals(getAutuData)){
				http= AssembleTool.assembleRequestForObjectParam(message.getHttpUrl(), message.getAuthDatas());
			}else {
				http= AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			}
		} else if(customService.isAliTrip(appId)){
			http = CaiNiaoTool.setHttpRequestHeader(message.getHttpUrl(), message.getAuthParams());
		} else if(customService.isHaiDiLao(appId)){
			http = customService.setHaidilaoVirtualHttpHeader( message, http);
		} else if (customService.isFunHeadlines(appId)) {
			http = customService.resetFunHeadlinesVirtualHttpType(message, http);
		} else if(customService.isRenrenTv(appId)) {
		    http = customService.setRenrenVirtualHttpHeader(message);
        } else if(customService.isSns(appId)){
			http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			customService.setSnsAddHttpHeader(message.getAuthParams(), http);
		} else if (customService.isBeingmate(appId)) {
			http = AssembleTool.assembleRequest(message.getHttpUrl(), message.getAuthParams());
			customService.setBeingmateHttpHeader(http);
		}else if(gangZhongLvApi.isGangZhongLv(appId)){
			http=gangZhongLvApi.getVirtualRequest(message);
		} else if (customService.isWatsons(appId)) {
			if (!SpringEnvironmentUtils.isProdEnv()) {
				log.info("屈臣氏虚拟商品充值请求参数：{}", JSON.toJSONString(message.getAuthParams()));
			}
			http = watsonsApi.getVirtualRequestHttp(message);
		} else if (customService.isHeBeiMobile(appId)) {
			http = AssembleTool.assembleRequestJson(message.getHttpUrl(), JSON.toJSONString(message.getAuthParams()));
		} else if (qiaQiaApi.isQiaQia(appId)) {
			http = qiaQiaApi.getVirtualRequest(message);
		} else if (wuFangZhaiApi.isWuFangZhai(appId)) {
			http = wuFangZhaiApi.getVirtualRequest(message);
		} else if (haoXiangNiApi.isHaoXiangNi(appId)) {
			http = haoXiangNiApi.getVirtualRequest(message);
		} else if (livatApi.isLivat(appId)) {
			http = livatApi.getVirtualRequest(message,appId);
		} else if (nongZongHangApi.isNongZongHang(appId)) {
            http = nongZongHangApi.getVirtualRequestHttp(message);
        } else if (newInoherbApi.isNewInoherb(appId)) {
			http = newInoherbApi.getVirtualRequest(message);
		} else if(guMingApi.isGuMing(appId)){
			http = guMingApi.getVirtualRequest(message);
		} else if (unionPayApi.isUnionPayApp(appId)) {
			http = unionPayApi.getVirtualRequest(message);
		} else if (siChuanLianTongApi.isSiChuanLianTongApp(appId)) {
			http = siChuanLianTongApi.getVirtualRequest(message);
		} else if (icbcElifeApi.isIcbcApp(appId)) {
			http = icbcElifeApi.getVirtualRequest(message);
		} else if (mingYuJiuDianApi.isAppId(appId)){
			http = mingYuJiuDianApi.getVirtualRequest(message);
		} else if (changChengApi.isChangCheng(appId)){
			http = changChengApi.getVirtualRequest(message);
		} else if (spdBankApi.isPdCardApp(appId)) {
			http = spdBankApi.getPdCardVirtualRequest(message);
		} else if (shanXiSecuritiesApi.isAppId(appId)) {
			http = shanXiSecuritiesApi.getVirtualRequest(message);
		} else if (hongQiApi.isHongQiAppid(appId)) {
			http = hongQiApi.getVirtualRequest(message);
		}  else if (ApiStrategyRouter.route(appId) != null) {
			HttpRequestBase httpRequestBase = ApiStrategyRouter.route(appId).getVirtualRequest(message);
			http = httpRequestBase != null ? httpRequestBase : new HttpGet(message.getHttpUrl());
		} else {
			http = getVirtualRequest(appId, message);
		}
		return http;
	}

	private HttpRequestBase getVirtualRequest(Long appId, SupplierRequest message) {
		if (huaweiApi.isHuaweiApp(appId)) {
			return huaweiApi.getVirtualRequest(message);
		}
		return new HttpGet(message.getHttpUrl());
	}

	private void finallyBlock(SupplierRequest message, SupplierResponse response, String callbackTopic, String msgTag, String msgKey, String code) {
		try {
			response.setUrl(message.getHttpUrl());
			response.setSupplierName(message.getSupplierName());
			response.setSupplierOrderId(message.getSupplierOrderId());
			response.setOrderId(message.getOrderId());
			response.setAppId(message.getAppId());
			response.setConsumerId(message.getConsumerId());
			String body = JsonTool.objectToJson(response);
			HttpRequestLog.logUrl("[action virtual] [tag response] [code "+code+"] [bizId " + message.getOrderId() + "] [body " + response.getBody() + "] [callback " + response.getCallbackType() + "]");
			if (nongZongHangApi.isNongZongHang(Long.valueOf(message.getAppId()))) {
				boolean needSendMq = nongZongHangApi.customFinallyBlock(message,response);
				if (!needSendMq) {
					return;
				}
			}
			if(callbackTopic.contains("MQ")){
				rocketMQMsgProducer.sendMsg(callbackTopic, msgTag, msgKey, body,false,null);
			}else{
				messageService.sendMsg(callbackTopic,msgTag,msgKey,body);
			}
			// 定制处理
			customDeal(message, response);
		} catch (Exception e) {
			log.error("VirtualSupplier callback:" + message.getOrderId(), e);
		}
	}

	private void customDeal(SupplierRequest request, SupplierResponse response) {
		if (pinganConfig.getAppIds().contains(Long.valueOf(request.getAppId()))) {
			log.info("request:{},response:{}", JSON.toJSONString(request), JSON.toJSONString(response));
			saveCreditsLog(request, response);
		}
	}

	/**
	 * 保存积分记录
	 *
	 * @param request
	 * @param response
	 */
	private void saveCreditsLog(SupplierRequest request, SupplierResponse response) {
		executorService.execute(() -> {
			if (response == null || StringUtils.isBlank(response.getBody())) {
				return;
			}

			CreditsMessageDto creditsRequest = BeanUtils.copy(request, CreditsMessageDto.class);
			CreditsCallbackMessage creditsResponse = BeanUtils.copy(response, CreditsCallbackMessage.class);

			creditsRequest.setRelationType(CreditsMessage.TYPE_EXCHANGE);
			creditsRequest.setTimestamp(System.currentTimeMillis());
			creditsResponse.setMessage(response.getBody());
			String url = request.getHttpUrl();
			String requestParams = url.substring(url.indexOf('?') + 1);
			Map<String, String> authParams = AssembleTool.getUrlParams(requestParams);
			authParams.put("type", CreditsMessage.TYPE_EXCHANGE);
			creditsRequest.setBizId(authParams.get("orderNum"));
			creditsRequest.setRelationId(authParams.get("orderNum"));
			authParams.put("credits", authParams.get("params").replace("DBJF_", ""));
			creditsRequest.setAuthParams(authParams);
			try {
				if (CreditsCallbackMessage.CALLBACK_TYPE_COMPLETED.equals(creditsResponse.getCallbackType())) {
					JSONObject json = JSON.parseObject(creditsResponse.getMessage());
					if (json != null && ("success".equalsIgnoreCase(json.getString("status")) || "ok".equalsIgnoreCase(json.getString("status")))) {
						consumerCreditsLogService.save(creditsRequest, creditsResponse);
					}
				}
			} catch (Exception e) {
				log.info("积分记录保存失败, creditsRequest:{},creditsResponse:{}", JSON.toJSONString(creditsRequest), JSON.toJSONString(creditsResponse), e);
			}
		});
	}

	private String getErrMsg(Exception e) {
		String causeMsg = "";
		if (StringUtils.isNotBlank(e.getMessage())) {
			if (e.getMessage().length() > 200) {
				causeMsg = e.getMessage().substring(0, 200);
			} else {
				causeMsg = e.getMessage();
			}
		}
		return causeMsg;
	}

}
