package cn.com.duiba.constant;

import cn.com.duiba.tool.huawei.SignUtils;
import com.google.common.collect.ImmutableSet;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Set;

/**
 * 华为商城配置
 * Created by xuwei on 2020/12/02.
 **/
@Configuration
@ConfigurationProperties(prefix = "huawei")
public class HuaweiConfig {

    private Set<Long> appIds = ImmutableSet.of(80380L);
    private String huaweiAppId = "103538629";
    private String addCreditsActCode = "PARTNERA";
    private String signAddCreditsActCode = "PORTALSIGN";
    private String consumeCreditsActCode = "PARTNERC";
    private String beCode;
    private String serviceUnit = "PARTNER1";
    private String vmallDeviceType = "PARTNER1";
    private String vmallDeviceAccount = "1053000";
    private String vmallDevicePassword = "Qm5zIqTAhZ0EHpNBYznXHzBLQRepBaKv";
    private String encryptSecret = "aUGHrNFeBtsGZzCQwinLcZolBq42JeEx";
    private String addCreditsPath = "/mcp/point/giftActivityPoints";
    private String receiveCouponBatchUrl = "/mcp/coupon/receiveCoupon";
    private String receiveCouponCodeUrl = "/mcp/coupon/receiveCouponWithCode";
    private String virtualTypeCredits = "CREDITS";
    private String virtualTypeCouponBatch = "BATCH";
    private String virtualTypeCouponCode = "CODE";

    private String privateKey = "MIIEvAIBADANBgkqhkiG9w0BAQEFAASCBKYwggSiAgEAAoIBAQDdxEuo+lDmqFan3Z3DG+KEuHvBHR3mugm+bM" +
            "PQ2QIU2U3boeWlleormvoHY6HYpFy48xCs/cW8jJQD2mtPCFqtJv+lZkKBw1WiC25Yv+KmcciuLKJtxmn8ijpStCnvYYdwbN0gMTo9f79U" +
            "qkQ5d2JWGNn0uApKzQ6dyubDuhtPrHtbwv0pcYyzFFPg7YNqAd689Tg9dR79F/YXlp1MM7qQBumN7KvTp7Lhhcg78ehWwWMwf4fKw9VkqW" +
            "QCM+sftpeFcFULTHn4Arf6g1FbziQW8zu3yV5PejzEezq1Ad+kYflRvjhQhiWS1ls/HbzJfkjKsX/7K7Ry3uhLfXG6oVrXAgMBAAECggEA" +
            "ePnHKFP85Ab61rH/iNriU/JrmCoxEJd2D0o3++sVxpfQcDq+EvlX+Befw34nYQ4wgrgd5bC+OKAbcoqpNUDibkiy9uB08WLEiRRhSsrKcm" +
            "/pwJIavXWahahGLq2Xnr1+a+cHLbONCNVyY1ZKx2qH213NMEFhY/K+wXdZMXaJxYjW+oDAsVndxiCgFNFWcNrlQEN2lbksmCkfL9lVCr78" +
            "+6EwCU6WpJrSHxeiUfYJP55cucU4sIZnss7VeUczb+RaPg9GDIA5cPDlpPBH31L2cgyFy1CzE5T9FaH/qVWxKNmyOqwt7MUO8C9xCyQBVW" +
            "AOhtmuXy1nYQkp6Ht/q/kyGQKBgQDxiz92HGFjN8SXKQTJZTBuL3n067a2bBwCd9QNZYy+ZtZL18hDjnKPokVE6oq/f8VTRT/fmK6x/7Ud" +
            "BBj3OdzHYVcVqQG3vYRCHqVh027hEQgIxZbzoPZ5Pq3DFtJVi9gXxlgOkzRgTsfn4ZuZ5pp7GVuc8mQlQFp3/4SOIZH6RQKBgQDrCgmAbx" +
            "EZZEtYoYdyj7mWOUDBJQx+MjyUwpfBsDeGQa2V/vYg4nHY+Guz9o2q/nieeNRF1O3cTVApHhvHOqfhhirDAVluZ6WEeZLJP2KJLteO+cxJ" +
            "9J/B0GFL6gWAwSa0ozSMw62dcZwWISwl3prhV5jNKq36QpMjzVyvjuLAawKBgCGykoTwyqlj41pPT6qlIk+M8g+4PsJObM3vV7cSvsLlZ+" +
            "omzXqXSeY99jn6GqdCtQ278IBKNb0Bdov4wV7kRKfQLa0I6gNvPh9XVS1DqQlfLebDYh7VCu25T9aSvX9PxjLy6eAGq1zwQLVZ5TJgWJbp" +
            "370Sl+QWiUiKbjzB9DKdAoGAEZHPggVLbu17YGW6vUqXIe6ns4h0dZ6Fvs0JERZ+IBAazMKhXXXv8rsnOe2tS2H4XEhF/e5b1YMGAfzZML" +
            "xmvkoMOkWIjOM8kTmRSm/tirmwrWRo7AJYSuGr1EPrI2PM4+XrULZz7PgIJfNW3IHWbA/jQTr2hGWjoCKC0jDJLH8CgYA3keud2ibgQZDt" +
            "eUZrAxoqGDgfsLeCObq1/9+7bfTvRcoxBmx6U49frcyKkT9OdZoO8+DuEi7SwhjZ6VWsNX/+kiaqpFK9r+GcqofTkRn6TZIVXswoeJLcHD" +
            "RDWe+vz0ep4z9BG5OWk+8aRY/r39wGBBVV6A9o6FrwcX1jOGeXOw==";

    private String publicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3cRLqPpQ5qhWp92dwxvihLh7wR0d5roJvmzD0NkCFNl" +
            "N26HlpZXqK5r6B2Oh2KRcuPMQrP3FvIyUA9prTwharSb/pWZCgcNVogtuWL/ipnHIriyibcZp/Io6UrQp72GHcGzdIDE6PX+/VKpEOXdiV" +
            "hjZ9LgKSs0Oncrmw7obT6x7W8L9KXGMsxRT4O2DagHevPU4PXUe/Rf2F5adTDO6kAbpjeyr06ey4YXIO/HoVsFjMH+HysPVZKlkAjPrH7a" +
            "XhXBVC0x5+AK3+oNRW84kFvM7t8leT3o8xHs6tQHfpGH5Ub44UIYlktZbPx28yX5IyrF/+yu0ct7oS31xuqFa1wIDAQAB";

    private PrivateKey privateKeyInstance;

    private PublicKey publicKeyInstance;

    public Set<Long> getAppIds() {
        return appIds;
    }

    public void setAppIds(Set<Long> appIds) {
        this.appIds = appIds;
    }

    public boolean isHuaweiApp(Long appId) {
        return appIds != null && appIds.contains(appId);
    }

    public String getHuaweiAppId() {
        return huaweiAppId;
    }

    public void setHuaweiAppId(String huaweiAppId) {
        this.huaweiAppId = huaweiAppId;
    }

    public String getAddCreditsActCode() {
        return addCreditsActCode;
    }

    public void setAddCreditsActCode(String addCreditsActCode) {
        this.addCreditsActCode = addCreditsActCode;
    }

    public String getSignAddCreditsActCode() {
        return signAddCreditsActCode;
    }

    public void setSignAddCreditsActCode(String signAddCreditsActCode) {
        this.signAddCreditsActCode = signAddCreditsActCode;
    }

    public String getConsumeCreditsActCode() {
        return consumeCreditsActCode;
    }

    public void setConsumeCreditsActCode(String consumeCreditsActCode) {
        this.consumeCreditsActCode = consumeCreditsActCode;
    }

    public String getBeCode() {
        return beCode;
    }

    public void setBeCode(String beCode) {
        this.beCode = beCode;
    }

    public String getServiceUnit() {
        return serviceUnit;
    }

    public void setServiceUnit(String serviceUnit) {
        this.serviceUnit = serviceUnit;
    }

    public String getVmallDeviceType() {
        return vmallDeviceType;
    }

    public void setVmallDeviceType(String vmallDeviceType) {
        this.vmallDeviceType = vmallDeviceType;
    }

    public String getVmallDeviceAccount() {
        return vmallDeviceAccount;
    }

    public void setVmallDeviceAccount(String vmallDeviceAccount) {
        this.vmallDeviceAccount = vmallDeviceAccount;
    }

    public String getVmallDevicePassword() {
        return vmallDevicePassword;
    }

    public void setVmallDevicePassword(String vmallDevicePassword) {
        this.vmallDevicePassword = vmallDevicePassword;
    }

    public String getEncryptSecret() {
        return encryptSecret;
    }

    public void setEncryptSecret(String encryptSecret) {
        this.encryptSecret = encryptSecret;
    }

    public String getAddCreditsPath() {
        return addCreditsPath;
    }

    public void setAddCreditsPath(String addCreditsPath) {
        this.addCreditsPath = addCreditsPath;
    }

    public String getReceiveCouponBatchUrl() {
        return receiveCouponBatchUrl;
    }

    public void setReceiveCouponBatchUrl(String receiveCouponBatchUrl) {
        this.receiveCouponBatchUrl = receiveCouponBatchUrl;
    }

    public String getReceiveCouponCodeUrl() {
        return receiveCouponCodeUrl;
    }

    public void setReceiveCouponCodeUrl(String receiveCouponCodeUrl) {
        this.receiveCouponCodeUrl = receiveCouponCodeUrl;
    }

    public String getVirtualTypeCredits() {
        return virtualTypeCredits;
    }

    public void setVirtualTypeCredits(String virtualTypeCredits) {
        this.virtualTypeCredits = virtualTypeCredits;
    }

    public String getVirtualTypeCouponBatch() {
        return virtualTypeCouponBatch;
    }

    public void setVirtualTypeCouponBatch(String virtualTypeCouponBatch) {
        this.virtualTypeCouponBatch = virtualTypeCouponBatch;
    }

    public String getVirtualTypeCouponCode() {
        return virtualTypeCouponCode;
    }

    public void setVirtualTypeCouponCode(String virtualTypeCouponCode) {
        this.virtualTypeCouponCode = virtualTypeCouponCode;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public void setPrivateKey(String privateKey) {
        this.privateKey = privateKey;
    }

    public String getPublicKey() {
        return publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public PrivateKey getPrivateKeyInstance() {
        if (privateKeyInstance != null) {
            return privateKeyInstance;
        }
        try {
            return privateKeyInstance = SignUtils.getPrivateKey(privateKey);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public PublicKey getPublicKeyInstance() {
        if (publicKeyInstance != null) {
            return publicKeyInstance;
        }
        try {
            return publicKeyInstance = SignUtils.getPublicKey(publicKey);
        } catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        HuaweiConfig config = new HuaweiConfig();
        System.out.println("私钥：");
        System.out.println(config.getPrivateKey());
        System.out.println("公钥：");
        System.out.println(config.getPublicKey());
        System.out.println("密钥");
        System.out.println(SignUtils.sha256(config.getEncryptSecret()));
    }
}
