package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.PuhuiApiStrategy;
import com.google.common.collect.Sets;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import javax.annotation.Resource;
import java.util.Set;

/**
 * @author fja
 * @since 2021-06-07
 */
@Configuration
@ConfigurationProperties(prefix = "puhui")
public class PuhuiConfig implements InitializingBean {

    @Resource
    private PuhuiApiStrategy puhuiApiStrategy;

    private Set<Long> appIdSet = Sets.newHashSet(1L);

    private String md5Secret = "3050sk6g6sner4er";

    /**
     * aes秘钥
     */
    private String aesSecret = "3050sk6g6sner4el";

    /**
     * channelId
     */
    private String channelId = "2009";

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public PuhuiApiStrategy getPuhuiApiStrategy() {
        return puhuiApiStrategy;
    }

    public void setPuhuiApiStrategy(PuhuiApiStrategy puhuiApiStrategy) {
        this.puhuiApiStrategy = puhuiApiStrategy;
    }

    public String getChannelId() {
        return channelId;
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public String getMd5Secret() {
        return md5Secret;
    }

    public void setMd5Secret(String md5Secret) {
        this.md5Secret = md5Secret;
    }

    public String getAesSecret() {
        return aesSecret;
    }

    public void setAesSecret(String aesSecret) {
        this.aesSecret = aesSecret;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIdSet, puhuiApiStrategy);
    }
}
