package cn.com.duiba.constant;

import cn.com.duiba.biz.credits.strategy.ApiStrategyRouter;
import cn.com.duiba.biz.credits.strategy.Impl.WandaApiStrategy;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * 万达酒店配置
 *
 * @author fja
 * @since 2021-04-19
 */
@Configuration
@ConfigurationProperties(prefix = "wanda")
public class WandaConfig implements InitializingBean {

    @Resource
    private WandaApiStrategy wandaApiStrategy;

    private Set<Long> appIdSet = Sets.newHashSet(1L);
    /**
     * 授权对应账户信息JSON字符串
     */
    private String authStr = "";

    private Map<String, String> authParams = new HashMap<>();

    /**
     * token请求链接
     */
    private String queryTokenUrl = "https://platform.wandahotels.com/sso-auth/token";

    /**
     * 查询用户积分
     */
    private String queryCreditsUrl = "https://platform-dev.wandahotels.com/crm-service/2b/point/getPointsByCardNo";
    /**
     * 默认酒店编码
     */
    private String defaultStoreCode;

    /**
     * mq延时30秒
     */
    private Integer msgDelayLevel = 4;

    public Map<String, String> getAuthParams() {
        return authParams;
    }

    public void setAuthParams(Map<String, String> authParams) {
        this.authParams = authParams;
    }

    public Set<Long> getAppIdSet() {
        return appIdSet;
    }

    public void setAppIdSet(Set<Long> appIdSet) {
        this.appIdSet = appIdSet;
    }

    public String getQueryTokenUrl() {
        return queryTokenUrl;
    }

    public String getQueryCreditsUrl() {
        return queryCreditsUrl;
    }

    public void setQueryCreditsUrl(String queryCreditsUrl) {
        this.queryCreditsUrl = queryCreditsUrl;
    }

    public void setQueryTokenUrl(String queryTokenUrl) {
        this.queryTokenUrl = queryTokenUrl;
    }

    public String getAuthStr() {
        return authStr;
    }

    public void setAuthStr(String authStr) {
        this.authStr = authStr;
    }

    public String getDefaultStoreCode() {
        return defaultStoreCode;
    }

    public void setDefaultStoreCode(String defaultStoreCode) {
        this.defaultStoreCode = defaultStoreCode;
    }

    public Integer getMsgDelayLevel() {
        return msgDelayLevel;
    }

    public void setMsgDelayLevel(Integer msgDelayLevel) {
        this.msgDelayLevel = msgDelayLevel;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        ApiStrategyRouter.register(appIdSet, wandaApiStrategy);
        if (StringUtils.isNotBlank(authStr)) {
            this.authParams = JSON.parseObject(authStr, Map.class);
        }
        DelayNotifyConfig.setDelayLevels(appIdSet, msgDelayLevel);
    }
}
