package cn.com.duiba.constant.nongzonghang;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @author haojiahong
 * @date 2020-07-20
 * 兑吧集团在福禄后台开了两个账号，方便财务对账，如开发者对接福禄前先问清楚走哪个账号
 */
@Configuration
@ConfigurationProperties(prefix = "nongzonghang.fulu")
public class FuLuConfig implements InitializingBean {

    private Map<Long, String> appItemProductMap;
    private String appItemProductConfig;


    private String url = "http://pre.openapi.fulu.com/api/getway";
    //兑吧账号的appKey
    private String appKey = "i4esv1l+76l/7NQCL3QudG90Fq+YgVfFGJAWgT+7qO1Bm9o/adG/1iwO2qXsAXNB";
    //兑吧账号的sysSecret
    private String sysSecret = "0a091b3aa4324435aab703142518a8f7";

    //兑啊账号的appKey
    private String duiaAppKey = "xaeCLEFwMjSi+b9bG1ap5ev7UUJxgs0TYl6zMWjuZDBPvC6bnjW/dSVFY6sgsvww";
    //兑啊账号的sysSecret
    private String duiaSysSecret = "00be924629e04acd8624b4f1a0596ced";

    public Map<Long, String> getAppItemProductMap() {
        return appItemProductMap;
    }

    public void setAppItemProductMap(Map<Long, String> appItemProductMap) {
        this.appItemProductMap = appItemProductMap;
    }

    public String getAppItemProductConfig() {
        return appItemProductConfig;
    }

    public void setAppItemProductConfig(String appItemProductConfig) {
        this.appItemProductConfig = appItemProductConfig;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public String getSysSecret() {
        return sysSecret;
    }

    public void setSysSecret(String sysSecret) {
        this.sysSecret = sysSecret;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isNotBlank(appItemProductConfig)) {
            appItemProductMap = new HashMap<>();
            JSONObject jsonObject = JSON.parseObject(appItemProductConfig);
            for (Map.Entry<String, Object> entry : jsonObject.entrySet()) {
                appItemProductMap.put(Long.valueOf(entry.getKey()), entry.getValue().toString());
            }
        }
    }

    public enum Api {
        /**
         * 直充下单接口
         */
        ORDER_DIRECT_ADD("fulu.order.direct.add"),
        /**
         * 订单查询接口
         */
        ORDER_INFO_GET("fulu.order.info.get"),
        /**
         * 话费充值接口
         */
        ORDER_MOBILE_GET("fulu.order.info.get"),
        ;

        String methodName;

        Api(String methodName) {
            this.methodName = methodName;
        }

        public String getMethodName() {
            return methodName;
        }
    }

    public String getDuiaAppKey() {
        return duiaAppKey;
    }

    public void setDuiaAppKey(String duiaAppKey) {
        this.duiaAppKey = duiaAppKey;
    }

    public String getDuiaSysSecret() {
        return duiaSysSecret;
    }

    public void setDuiaSysSecret(String duiaSysSecret) {
        this.duiaSysSecret = duiaSysSecret;
    }
}
