package cn.com.duiba.dao.impl;

import cn.com.duiba.constant.DatabaseSchema;
import cn.com.duiba.dao.AppNewExtraDao;
import cn.com.duiba.dao.BaseDAO;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.concurrent.TimeUnit;

/**
 * Created by xiaoxuda on 2017/8/30.
 */
@Repository
public class AppNewExtraDaoImpl extends BaseDAO implements AppNewExtraDao {
    public static final String APPID = "appId";
    public static final String BD = "bd";//bd联系人
    public static final String DAILY_ACT_LOGIN_UV = "dailyActLoginUv";//上月日均活动登录UV
    public static final String ONLINE_DATE = "onlineDate";//上线日期
    public static final String FLOWRULE = "flowRule";
    public static final String COUPON_STOCK_WARN = "couponStockWarn";//自有优惠券/虚拟商品库存预警线
    public static final String OBJECT_STOCK_WARN = "objectStockWarn";//自有实物库存预警线
    public static final String NOT_LOGIN_PLAY_GAME = "notLoginPlayGame";//未登录是否可以参与游戏
    public static final String SEC_KILL_VALIDATION_KEY = "secKillValidation"; //秒杀验证码类型
    public static final String EXCHANGE_VALIDATION_KEY = "exchangeValidation"; //普兑验证码类型
    public static final String CONSUME_VIRTUAL_CARD = "consumeVirtualCard";//扣虚拟卡链接key
    public static final String CONSUME_VIRTUAL_CARD_NOTIFY = "consumeVirtualCardNotify";//扣虚拟卡链接key

    public static final String POSTSALE_NOTIFY = "postsaleNotify";//售后完成通知链接key

    public static final String DELIVER_OBJECT_ORDER_NOTIFY = "DeliverObjectOrderNotify";//实物发货通知接口地址
    public static final String ACCESSACCOUNT = "accessAccount";//是否开启账号体系


    private Cache<String, String> appCache = CacheBuilder.newBuilder().expireAfterWrite(1, TimeUnit.MINUTES).build();

    @Override
    public String findVirtualCardConsume(Long appId) {
        String val = appCache.getIfPresent(appId + "_" + CONSUME_VIRTUAL_CARD);
        if(val == null) {
            val = getSqlSession().selectOne("findVirtualCardConsume", appId);
            if(StringUtils.isNotBlank(val)){
                appCache.put(appId + "_" + CONSUME_VIRTUAL_CARD, val);
            }
        }
        return val;
    }

    @Override
    public String findVirtualCardConsumeNotify(Long appId) {
        String val = appCache.getIfPresent(appId + "_" + CONSUME_VIRTUAL_CARD_NOTIFY);
        if(val == null) {
            val = getSqlSession().selectOne("findVirtualCardConsumeNotify", appId);
            if(StringUtils.isNotBlank(val)){
                appCache.put(appId + "_" + CONSUME_VIRTUAL_CARD_NOTIFY, val);
            }
        }
        return val;
    }

    @Override
    public String findDeliverObjectOrderNotify(Long appId) {
        String val = appCache.getIfPresent(appId + "_" + DELIVER_OBJECT_ORDER_NOTIFY);
        if(val == null) {
            val = getSqlSession().selectOne("findDeliverObjectOrderNotify", appId);
            if(StringUtils.isNotBlank(val)){
                appCache.put(appId + "_" + DELIVER_OBJECT_ORDER_NOTIFY, val);
            }
        }
        return val;
    }



    @Override
    public String findAccessAccountStatus(Long appId) {
        String val = appCache.getIfPresent(appId + "_" + ACCESSACCOUNT);
        if(val == null) {
            val = getSqlSession().selectOne("findAccessAccountStatus", appId);
            if(StringUtils.isNotBlank(val)){
                appCache.put(appId + "_" + ACCESSACCOUNT, val);
            }
        }
        return val;
    }

    /**
     * 获取售后完成通知接口地址
     *
     * @param appId
     **/
    @Override
    public String findPostsaleNotify(Long appId) {
        String val = appCache.getIfPresent(appId + "_" + POSTSALE_NOTIFY);
        if(val == null) {
            val = getSqlSession().selectOne("findPostsaleNotify", appId);
            if(StringUtils.isNotBlank(val)){
                appCache.put(appId + "_" + POSTSALE_NOTIFY, val);
            }
        }
        return val;
    }

    @Override
    protected DatabaseSchema chooseSchema() {
        return DatabaseSchema.CREDITS;
    }
}
