package cn.com.duiba.service;

import cn.com.duiba.domain.HttpMessageDO;

/**
 * HTTP异常重试规则服务
 */
public interface HttpRetryRulesService {

	/**
	 * 获取默认规则60,180,300,600,1200
	 * 
	 * @return
	 */
	public String[] getDefaultRetry();

	/**
	 * 根据业务类型获取规则，没有返回默认
	 * 
	 * @param db
	 * @return
	 */
	public String[] getRetryRule(HttpMessageDO db);

	/**
	 * 获取下次重试秒数
	 * 
	 * @param db
	 * @return
	 */
	public Integer getNextSecond(HttpMessageDO db);

	/**
	 * 获取重试规则的重试总数
	 * 
	 * @param db
	 * @return
	 */
	public Integer getRetryNumber(HttpMessageDO db);
	
	/**
	 * 更新下次重试时间
	 * @param db
	 */
	public void updateNextTime(HttpMessageDO db);
}
