package cn.com.duiba.service.impl;

import cn.com.duiba.constant.kouweiwang.KwwConfig;
import cn.com.duiba.dto.kouweiwang.KwwOrderSyncResp;
import cn.com.duiba.service.KwwOrderSyncService;
import cn.com.duiba.thirdparty.dto.kouweiwang.KwwOrderSyncDto;
import cn.com.duiba.tool.kouweiwang.KwwTool;
import com.alibaba.fastjson.JSON;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;

/**
 * @author fja
 */
@Service
public class KwwOrderSyncServiceImpl implements KwwOrderSyncService {

    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Resource(name = "shotKeepAliveHttpClient")
    private CloseableHttpClient httpClient;

    @Resource
    private KwwTool kwwTool;

    @Resource
    private KwwConfig kwwConfig;

    private final RequestConfig config;
    private static final int THREE_SECONDS = 3 * 1000;

    {
        //http请求超时配置
        config = RequestConfig.custom().setConnectTimeout(THREE_SECONDS).setSocketTimeout(THREE_SECONDS).setConnectionRequestTimeout(500).build();
    }


    @Override
    public void sendOrderInfo2Developer(KwwOrderSyncDto kwwOrderSyncDto) {
        HttpPost httpPost = new HttpPost(kwwConfig.getOrderSyncUrl());
        try {
            //加密
            String cipherText = kwwTool.aesEncrypt(JSON.toJSONString(kwwOrderSyncDto));
            log.info("[kww]减积分加密参数 = {}", cipherText);
            httpPost.setEntity(new StringEntity(cipherText, ContentType.APPLICATION_JSON));
            httpPost.setConfig(config);
        } catch (Exception e) {
            log.error("[kww]订单同步 加密异常", e);
            throw new IllegalStateException(e);
        }


        try (CloseableHttpResponse httpResponse = httpClient.execute(httpPost)) {
            String resp = EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
            KwwOrderSyncResp kwwOrderSyncResp = JSON.parseObject(resp, KwwOrderSyncResp.class);

            if (!KwwOrderSyncResp.SUCCESS.equals(kwwOrderSyncResp.getFlag())) {
                throw new IllegalStateException(kwwOrderSyncResp.getMsg());
            }
        } catch (Exception e) {
            log.error(String.format("[kww]订单 = %s 同步 发送异常", kwwOrderSyncDto.getOrderNum()), e);
            throw new IllegalStateException(e);
        }
    }
}
