package cn.com.duiba.tool;

import cn.hutool.core.codec.Base64;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by zhangyongjie on 2021/6/8 6:56 下
 */
public class DES3Tool {
    private static final String KEY_ALGORITHM = "DESede";
    private static final String DEFAULT_CIPHER_ALGORITHM = "DESede/ECB/PKCS5Padding";// 默认的加密算法

    /**
     * 加密
     *
     * @param value
     * @param key
     * @return
     * @throws Exception
     */
    public static String getEncryptedValue(String value, String key) throws Exception {
        if (null == value || "".equals(value)) {
            return "";
        }
        byte[] valueByte = value.getBytes();
        byte[] sl = encrypt3DES(valueByte, hexToBytes(key));
        return org.apache.commons.codec.binary.Base64.encodeBase64String(sl);
    }

    public static String getDecryptedValue(String value, String key) throws Exception {
        if (null == value || "".equals(value)) {
            return "";
        }

        byte[] valueByte = Base64.decode(value);
        byte[] sl = decrypt3DES(valueByte, hexToBytes(key));
        String result = new String(sl);
        return result;

    }

    public static byte[] encrypt3DES(byte[] input, byte[] key) throws Exception {
        Cipher c = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        c.init(Cipher.ENCRYPT_MODE, new SecretKeySpec(key, KEY_ALGORITHM));
        return c.doFinal(input);
    }

    public static byte[] decrypt3DES(byte[] input, byte[] key) throws Exception {
        Cipher c = Cipher.getInstance(DEFAULT_CIPHER_ALGORITHM);
        c.init(Cipher.DECRYPT_MODE, new SecretKeySpec(key, KEY_ALGORITHM));
        return c.doFinal(input);
    }


    private static byte[] hexToBytes(String hex) {

        return hexToBytes(hex.toCharArray());
    }

    private static byte[] hexToBytes(char[] hex) {
        int length = hex.length / 2;
        byte[] raw = new byte[length];
        for (int i = 0; i < length; i++) {
            int high = Character.digit(hex[i * 2], 16);
            int low = Character.digit(hex[i * 2 + 1], 16);
            int value = (high << 4) | low;
            if (value > 127) {
                value -= 256;
            }
            raw[i] = (byte) value;
        }
        return raw;
    }


    public static void main(String[] args) throws Exception {
        String content = "测试3DES";
        String key = "b59ed08aab57fef2d07c6bd629836bd0b59ed08aab57fef2";
        System.out.println("content:" + content);
        String s1 = DES3Tool.getEncryptedValue(content, key);
        System.out.println("加密:" + s1);
        System.out.println("解密:" + DES3Tool.getDecryptedValue(s1, key));

        String mobile = "13474980323";
        String key1 = "b59ed08aab57fef2d07c6bd629836bd0b59ed08aab57fef2";
        System.out.println("加密："+DES3Tool.getEncryptedValue(mobile,key1));

        Map<String,String> map = new HashMap<>();
        map.put("65523","111");
        System.out.println(map.get(String.valueOf(65523L)));
    }


}