/**
 * 
 */
package cn.com.duiba.tool;

/**
 * 此类描述的是： 项目错误码<br>
 * 错误码组成：AABBCCC
 * <ul>
 * AA：模块编号
 * <li>00：通用错误</li>
 * <li>01：平台券商品模块</li>
 * <li>02：券码库模块(批次和券码)</li>
 * </ul>
 * <ul>
 * BB：错误类型
 * <li>01 - 应用级错误（前端参数错误）</li>
 * <li>02 - 业务级错误（service自身错误）</li>
 * <li>03 - 依赖级错误（service调用第三方服务错误）  </li>
 * <li>04 - 交互级业务提醒（正常业务逻辑，非错误，需告知用户，如库存不足）  </li>
 * </ul>
 * <ul>
 * <ul>
 * CCC:具体错误码 举例
 * <li>通用的成功状态码：0000000</li>
 * <li>通用的未知错误码：9999999</li>
 * <li>参数验证错误码：0001001</li>
 * </ul>
 * .
 * @see http://cf.dui88.com/pages/viewpage.action?pageId=3544570
 * @version: 2016年2月18日 下午3:36:01
 */
public enum ErrorCode {

    /**参数错误**/
    E0001001("0001001", "参数错误"),

    /** 数据库异常. */
    E0102001("0102001", "数据库异常"),

    /** 未知错误. */
    E9999999("9999999", "发生系统未知错误");

    /** 错误码. */
    private String code;

    /** 中文描述. */
    private String desc;

    /**
     * The Constructor.
     *
     * @param errorCode the error code
     * @param desc the desc
     */
    private ErrorCode(String errorCode, String desc) {
        this.code ="GC-"+ errorCode;
        this.desc = desc;
    }

    /**
     * Gets the error code.
     *
     * @return the error code
     */
    public String getErrorCode() {
        return code;
    }

    /**
     * Gets the desc.
     *
     * @return the desc
     */
    public String getDesc() {
        return desc;
    }

}
