package cn.com.duiba.tool.kouweiwang;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.constant.kouweiwang.KwwConfig;
import cn.com.duiba.tool.boc.ConverTool;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

/**
 * @author fja
 */
@Component
public class KwwTool {
    /**
     * 加密算法
     */
    private static final String ALGORITHM_AES = "ALGORITHM";

    /**
     * 填充类型
     */
    private final static String AES_PADDING_MODE = "AES/ECB/PKCS5Padding";


    @Resource
    private KwwConfig kwwConfig;


    /**
     * aes加密
     *
     * @param plainText 明文
     * @return 密文
     * @throws Exception 加密异常
     */
    public String aesEncrypt(String plainText) throws Exception {

        SecretKeySpec secretKeySpec = new SecretKeySpec(kwwConfig.getAesKey(), ALGORITHM_AES);

        Cipher cipher = Cipher.getInstance(AES_PADDING_MODE);
        cipher.init(Cipher.ENCRYPT_MODE, secretKeySpec);

        //加密
        byte[] cipherText = cipher.doFinal(plainText.getBytes(StandardCharsets.UTF_8));

        return parseByte2HexStr(cipherText);
    }


    /**
     * aes解密
     *
     * @param cipherText 密文
     * @return 明文
     * @throws Exception 解密异常
     */
    public String aesDecrypt(String cipherText) throws Exception {
        SecretKeySpec secretKeySpec = new SecretKeySpec(kwwConfig.getAesKey(), ALGORITHM_AES);

        Cipher cipher = Cipher.getInstance(AES_PADDING_MODE);
        cipher.init(Cipher.DECRYPT_MODE, secretKeySpec);

        byte[] cipherBytes = ConverTool.parseHexStr2Byte(cipherText);

        if(Objects.isNull(cipherBytes)) {
            throw new BizException(String.format("16进制转换异常 cipherText = %s", cipherText));
        }

        byte[] original = cipher.doFinal(cipherBytes);

        return new String(original, StandardCharsets.UTF_8);

    }


    /**
     * 截取域名
     *
     * @param url 请求链接
     * @return 域名
     */
    public String getHostName(String url) {
        return url.substring(0, url.indexOf('?'));
    }

    /**
     * 截取参数
     *
     * @param url 请求链接
     * @return 参数
     */
    public String getParamUrl(String url) {
        return url.substring(url.indexOf('?') + 1);
    }


    /**
     * 将二进制转换成16进制
     *
     * @param bytes 字节数组
     */
    private String parseByte2HexStr(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            builder.append(hex.toUpperCase());
        }
        return builder.toString();
    }
}
