package org.gitlab.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.Date;

/**
 * http://gitlab2.dui88.com/help/api/merge_requests.md
 * project merge requests
 * Created by sunchangji on 2018/12/5.
 */
public class GitlabProjectMerges {

	@JsonProperty("project_id")
	private Integer projectId;

	private String state;

	private String title;

	private String description;

	@JsonProperty("merged_at")
	private Date mergedAt;

	@JsonProperty("created_at")
	private Date createdAt;

	@JsonProperty("updated_at")
	private Date updatedAt;

	@JsonProperty("target_branch")
	private String targetBranch;

	@JsonProperty("source_branch")
	private String sourceBranch;

	@JsonProperty("source_project_id")
	private Integer sourceProjectId;

	@JsonProperty("target_project_id")
	private Integer targetProjectId;

	/**
	 * 合并人信息,就是这个变动合并时谁合并的
	 */
	@JsonProperty("merged_by")
	private GitlabUserSimpleInfo mergedBy;

	/**
	 * 修改代码人员信息,也是提交合并请求人的信息
	 */
	private GitlabUserSimpleInfo author;

	/**
	 * 指订审核的人员信息
	 */
	private GitlabUserSimpleInfo assignee;

	public Integer getProjectId() {
		return projectId;
	}

	public void setProjectId(Integer projectId) {
		this.projectId = projectId;
	}

	public String getState() {
		return state;
	}

	public void setState(String state) {
		this.state = state;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Date getMergedAt() {
		return mergedAt;
	}

	public void setMergedAt(Date mergedAt) {
		this.mergedAt = mergedAt;
	}

	public Date getCreatedAt() {
		return createdAt;
	}

	public void setCreatedAt(Date createdAt) {
		this.createdAt = createdAt;
	}

	public Date getUpdatedAt() {
		return updatedAt;
	}

	public void setUpdatedAt(Date updatedAt) {
		this.updatedAt = updatedAt;
	}

	public String getTargetBranch() {
		return targetBranch;
	}

	public void setTargetBranch(String targetBranch) {
		this.targetBranch = targetBranch;
	}

	public String getSourceBranch() {
		return sourceBranch;
	}

	public void setSourceBranch(String sourceBranch) {
		this.sourceBranch = sourceBranch;
	}

	public Integer getSourceProjectId() {
		return sourceProjectId;
	}

	public void setSourceProjectId(Integer sourceProjectId) {
		this.sourceProjectId = sourceProjectId;
	}

	public Integer getTargetProjectId() {
		return targetProjectId;
	}

	public void setTargetProjectId(Integer targetProjectId) {
		this.targetProjectId = targetProjectId;
	}

	public GitlabUserSimpleInfo getMergedBy() {
		return mergedBy;
	}

	public void setMergedBy(GitlabUserSimpleInfo mergedBy) {
		this.mergedBy = mergedBy;
	}

	public GitlabUserSimpleInfo getAuthor() {
		return author;
	}

	public void setAuthor(GitlabUserSimpleInfo author) {
		this.author = author;
	}

	public GitlabUserSimpleInfo getAssignee() {
		return assignee;
	}

	public void setAssignee(GitlabUserSimpleInfo assignee) {
		this.assignee = assignee;
	}
}
