package cn.com.duiba.order.center.api.dto;

import java.io.Serializable;

public class ItemKeyDto implements Serializable{
	private static final long serialVersionUID = 1234212321L;

	private final ItemDto item;
	private final AppItemDto appItem;
	private final AppDto app;
	/**
	 * 开发者不得调用此方法！！！
	 * 此方法只提供给ItemKeyService调用！！
	 * @param item
	 * @param appItem
	 * @param app
	 * @return
	 */
	public static ItemKeyDto generate(ItemDto item, AppItemDto appItem, AppDto app){
		return new ItemKeyDto(item, appItem, app);
	}
	
	protected ItemKeyDto(ItemDto item, AppItemDto appItem, AppDto app){
		this.item=item;
		this.appItem=appItem;
		this.app=app;
	}

	private ItemKeyDto(){
		this.item=null;
		this.appItem=null;
		this.app=null;
	}
	/**
	 * 获取商品类型
	 * @return
	 */
	public String getItemType(){
		if(getItem()!=null){
			return getItem().getType();
		}
		if(getAppItem()!=null){
			return getAppItem().getType();
		}
		return null;
	}
	

	public ItemDto getItem() {
		return item;
	}

	public AppItemDto getAppItem() {
		return appItem;
	}
	/**
	 * 是否有效
	 * (某些情况下，商品被删除，导致无法加载出来，这个时候认为ItemKey无效)
	 * @return
	 */
	public boolean isValid(){
		return (getItem()!=null || getAppItem()!=null);
	}
	/**
	 * 是否Item模式
	 * @return
	 */
	public boolean isItemMode(){
		return item!=null && appItem==null;
	}
	/**
	 * 是否自有AppItem模式
	 * @return
	 */
	public boolean isSelfAppItemMode(){
		return item==null && appItem!=null;
	}
	/**
	 * 是否兑吧AppItem模式
	 * @return
	 */
	public boolean isDuibaAppItemMode(){
		return item!=null && appItem!=null;
	}

	public AppDto getApp() {
		return app;
	}
	
	public Boolean isAmbItemKey(){
	    if(this.isDuibaAppItemMode()){
	    	//加钱购不支持兑吧商品
	    	return false;
	    }else if(this.isSelfAppItemMode()) {
            return appItem.isOpTypeAppItem(ItemDto.OpTypeIsAmb);
        }else {
        	return item.isOpTypeItem(ItemDto.OpTypeIsAmb);
        }
	}
	
}
