package cn.com.duiba.order.center.api.dto.guess;

import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

import cn.com.duiba.service.domain.dataobject.ItemDO;

public class GuessOrdersDto implements Serializable {

	/**
	 * 
	 */
	private static final long serialVersionUID = -2557084110018031322L;

	public static final String PREFIX_ORDER = "guess-";

	public static final int StatusCreate = 0; // 创建
	public static final int StatusConsumeSuccess = 1; // 扣积分成功
	public static final int StatusSuccess = 2; // 订单完成
	public static final int StatusFail = 3; // 订单失败

	public static final int ExchangeStatusCreate = 0; // 创建
	public static final int ExchangeStatusWaitOpen = 1;// 待开奖
	public static final int ExchangeStatusWait = 2; // 待领取
	public static final int ExchangeStatusSuccess = 3; // 领奖成功
	public static final int ExchangeStatusOverdue = 4; // 未领取，过期
	public static final int ExchangeStatusFail = 5; // 领奖失败

	public static final String PrizeTypeVirtual = ItemDO.TypeVirtual; // 虚拟商品
	public static final String PrizeTypeAlipay = ItemDO.TypeAlipay; // 支付宝
	public static final String PrizeTypeQB = ItemDO.TypeQB; // QB
	public static final String PrizeTypeCoupon = ItemDO.TypeCoupon; // 优惠劵
	public static final String PrizeTypeObject = ItemDO.TypeObject; // 实物
	public static final String PrizeTypePhonebill = ItemDO.TypePhonebill; // 话费
	public static final String PrizeTypeThanks = "thanks"; // 谢谢参与
	public static final String PrizeTypeLuckBag = "lucky";//福袋lucky

	private Long id;
	private Long appId;
	private Long consumerId;
	private String partnerUserId;
	private Long operatingActivityId;
	private Long duibaGuessId;
	private Long itemId;
	private Long appItemId;
	private Long credits;
	private Long prizeId;
	private String prizeName;
	private String prizeType;
	private Date prizeOverdueDate;
	private String prizeFacePrice;
	private Long score;
	private Long couponId;
	private Integer orderStatus;
	private Integer exchangeStatus;
	private Long guessOrderExtraId;
	private Long mainOrderId;
	private String mainOrderNum;
	private String developerBizId;
	private String ip;
	private String error4admin;
	private String error4developer;
	private String error4consumer;
	private Date gmtCreate;
	private Date gmtModified;
	private String guessData;
	private Long consumerExchangeRecordId;
	private String guessRandomNum;
	private Integer isGivePrize;

	public GuessOrdersDto() {

	}

	public GuessOrdersDto(Long id) {
		this.id = id;
		this.gmtModified = new Date();
	}

	public GuessOrdersDto(boolean init4insert) {
		if (init4insert) {
			gmtCreate = new Date();
			gmtModified = new Date();
		}
	}

	public static synchronized String generateOrderNum(Long id) {
		return PREFIX_ORDER + id.toString();
	}

	public static synchronized String generateOrderToken() {
		String token = UUID.randomUUID().toString();
		token = token.replaceAll("-", "");
		return token;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Long getAppId() {
		return appId;
	}

	public void setAppId(Long appId) {
		this.appId = appId;
	}

	public Long getConsumerId() {
		return consumerId;
	}

	public void setConsumerId(Long consumerId) {
		this.consumerId = consumerId;
	}

	public String getPartnerUserId() {
		return partnerUserId;
	}

	public void setPartnerUserId(String partnerUserId) {
		this.partnerUserId = partnerUserId;
	}

	public Long getOperatingActivityId() {
		return operatingActivityId;
	}

	public void setOperatingActivityId(Long operatingActivityId) {
		this.operatingActivityId = operatingActivityId;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getAppItemId() {
		return appItemId;
	}

	public void setAppItemId(Long appItemId) {
		this.appItemId = appItemId;
	}

	public Long getCredits() {
		return credits;
	}

	public void setCredits(Long credits) {
		this.credits = credits;
	}

	public Long getPrizeId() {
		return prizeId;
	}

	public void setPrizeId(Long prizeId) {
		this.prizeId = prizeId;
	}

	public String getPrizeName() {
		return prizeName;
	}

	public void setPrizeName(String prizeName) {
		this.prizeName = prizeName;
	}

	public String getPrizeType() {
		return prizeType;
	}

	public void setPrizeType(String prizeType) {
		this.prizeType = prizeType;
	}

	public String getPrizeFacePrice() {
		return prizeFacePrice;
	}

	public void setPrizeFacePrice(String prizeFacePrice) {
		this.prizeFacePrice = prizeFacePrice;
	}

	public Long getScore() {
		return score;
	}

	public void setScore(Long score) {
		this.score = score;
	}

	public Long getCouponId() {
		return couponId;
	}

	public void setCouponId(Long couponId) {
		this.couponId = couponId;
	}

	public Integer getExchangeStatus() {
		return exchangeStatus;
	}

	public void setExchangeStatus(Integer exchangeStatus) {
		this.exchangeStatus = exchangeStatus;
	}

	public Long getMainOrderId() {
		return mainOrderId;
	}

	public void setMainOrderId(Long mainOrderId) {
		this.mainOrderId = mainOrderId;
	}

	public String getMainOrderNum() {
		return mainOrderNum;
	}

	public void setMainOrderNum(String mainOrderNum) {
		this.mainOrderNum = mainOrderNum;
	}

	public String getDeveloperBizId() {
		return developerBizId;
	}

	public void setDeveloperBizId(String developerBizId) {
		this.developerBizId = developerBizId;
	}

	public String getIp() {
		return ip;
	}

	public void setIp(String ip) {
		this.ip = ip;
	}

	public String getError4admin() {
		return error4admin;
	}

	public void setError4admin(String error4admin) {
		if (error4admin != null && error4admin.length() > 250) {
			error4admin = error4admin.substring(0, 250);
		}
		this.error4admin = error4admin;
	}

	public String getError4developer() {
		return error4developer;
	}

	public void setError4developer(String error4developer) {
		if (error4developer != null && error4developer.length() > 250) {
			error4developer = error4developer.substring(0, 250);
		}
		this.error4developer = error4developer;
	}

	public String getError4consumer() {
		return error4consumer;
	}

	public void setError4consumer(String error4consumer) {
		if (error4consumer != null && error4consumer.length() > 250) {
			error4consumer = error4consumer.substring(0, 250);
		}
		this.error4consumer = error4consumer;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public Date getGmtModified() {
		return gmtModified;
	}

	public void setGmtModified(Date gmtModified) {
		this.gmtModified = gmtModified;
	}

	public Date getPrizeOverdueDate() {
		return prizeOverdueDate;
	}

	public void setPrizeOverdueDate(Date prizeOverdueDate) {
		this.prizeOverdueDate = prizeOverdueDate;
	}

	public Integer getOrderStatus() {
		return orderStatus;
	}

	public void setOrderStatus(Integer orderStatus) {
		this.orderStatus = orderStatus;
	}

	public Long getDuibaGuessId() {
		return duibaGuessId;
	}

	public void setDuibaGuessId(Long duibaGuessId) {
		this.duibaGuessId = duibaGuessId;
	}

	public Long getGuessOrderExtraId() {
		return guessOrderExtraId;
	}

	public void setGuessOrderExtraId(Long guessOrderExtraId) {
		this.guessOrderExtraId = guessOrderExtraId;
	}

	public String getGuessData() {
		return guessData;
	}

	public void setGuessData(String guessData) {
		this.guessData = guessData;
	}

	public Long getConsumerExchangeRecordId() {
		return consumerExchangeRecordId;
	}

	public void setConsumerExchangeRecordId(Long consumerExchangeRecordId) {
		this.consumerExchangeRecordId = consumerExchangeRecordId;
	}

	public String getGuessRandomNum() {
		return guessRandomNum;
	}

	public void setGuessRandomNum(String guessRandomNum) {
		this.guessRandomNum = guessRandomNum;
	}

	public Integer getIsGivePrize() {
		return isGivePrize;
	}

	public void setIsGivePrize(Integer isGivePrize) {
		this.isGivePrize = isGivePrize;
	}
	
}
