package cn.com.duiba.order.center.api.remoteservice.amb;

import java.util.Date;
import java.util.List;
import java.util.Map;

import cn.com.duiba.order.center.api.dto.amb.AmbPostsaleOrdersDto;
import cn.com.duiba.order.center.api.vo.AmbPostsaleOrdersVO;

public interface RemoteAmbPostsaleOrdersService {

	public AmbPostsaleOrdersDto find(Long id);

	public AmbPostsaleOrdersDto findForUpdate(Long id);
	
	public AmbPostsaleOrdersDto findByOrderId(Long orderId);

	public AmbPostsaleOrdersDto insert(AmbPostsaleOrdersDto ambPostsaleOrders);

	public void update(AmbPostsaleOrdersDto ambPostsaleOrders);

	public void doAgree(Long id, String operateRemark, Date operateTime);

	public void doReject(Long id, String operateRemark, Date operateTime, Date finishTime);

	public void doCancel(Long id, Date finishTime);

	public void doComplete(Long id);

	public void doSuccess(Long id);
	
	public List<AmbPostsaleOrdersDto> findAllByIds(List<Long> ids);
	
	public List<AmbPostsaleOrdersDto> findAllByOrderId(Long orderId);
	
	public List<AmbPostsaleOrdersVO> findPageList(Long orderId,List<Long> appIds,Integer offset,Integer max);

    public Long findPageCount(Long orderId,List<Long> appIds);
    
    public Long findDealingCount();
    
    public void updateRejectAudit(Map<String, Object> queryMap);
}
