package cn.com.duiba.order.center.api.remoteservice.seckill;

import cn.com.duiba.order.center.api.dto.seckill.TakeOrderQueueDto;
import cn.com.duiba.order.center.api.dto.seckill.TakeOrderQueueRecordDto;
import cn.com.duiba.service.domain.vo.ItemKey;

import java.util.List;

/**
 * Created by yansen on 16/7/13.
 */
public interface RemoteTakeOrderQueueService {
    public TakeOrderQueueDto insertQueue(TakeOrderQueueDto queue) throws Exception;

    public TakeOrderQueueRecordDto insertRecord(TakeOrderQueueRecordDto record) throws Exception;

    public TakeOrderQueueRecordDto findRecordByQueueId(Long queueId);

    public TakeOrderQueueDto findQueue(Long id);

    public List<TakeOrderQueueDto> poll(int count)throws Exception;

    public int countQueueSize(String batchId);

    /**
     * 0: 没抢到
     * 1：抢到了
     * 2：排队中
     * @param queueId
     * @return
     */
    public int checkTakeOrderSuccess(Long queueId);

    public static final int SecondKillFail=0;//TODO yansen 看是否移到DTO或者common service
    public static final int SecondKillSuccess=1;
    public static final int SecondKillQueue=2;

    String generateBatchId(ItemKey itemKey);

}
